/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.authentication;

import dev.resteasy.client.util.common.Bytes;

public interface UserCredentials {
    public String getUsername();

    public byte[] getPassword();

    public static UserCredentials clear(final String username, char[] password) {
        final byte[] p = Bytes.charToBytes(password);
        return new UserCredentials(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public byte[] getPassword() {
                return (byte[])p.clone();
            }
        };
    }

    public static UserCredentials of(final String username, byte[] password) {
        final byte[] clone = (byte[])password.clone();
        return new UserCredentials(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public byte[] getPassword() {
                return (byte[])clone.clone();
            }
        };
    }
}

