/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class TrackingMap<V>
extends CaseInsensitiveMap<V>
implements MultivaluedMap<String, V>,
Cloneable {
    private final CaseInsensitiveMap<V> delegate;
    private final Set<String> addedOrUpdatedKeys;
    private final Set<String> removedKeys;

    public TrackingMap(CaseInsensitiveMap<V> delegate) {
        this(delegate, new HashSet<String>(), new HashSet<String>());
    }

    private TrackingMap(CaseInsensitiveMap<V> delegate, Set<String> addedOrUpdatedKeys, Set<String> removedKeys) {
        this.delegate = Objects.requireNonNull(delegate);
        this.addedOrUpdatedKeys = Objects.requireNonNull(addedOrUpdatedKeys);
        this.removedKeys = Objects.requireNonNull(removedKeys);
    }

    private void addToAddedOrUpdatedKeys(String key) {
        this.removedKeys.remove(key);
        this.addedOrUpdatedKeys.add(key);
    }

    private void addToRemovedKeys(String key) {
        this.removedKeys.add(key);
    }

    public Set<String> getAddedOrUpdatedKeys() {
        return Collections.unmodifiableSet(this.addedOrUpdatedKeys);
    }

    public Set<String> getRemovedKeys() {
        return Collections.unmodifiableSet(this.removedKeys);
    }

    public void add(String key, V value) {
        this.addToAddedOrUpdatedKeys(key);
        this.delegate.add((Object)key, value);
    }

    public void addFirst(String key, V value) {
        this.addToAddedOrUpdatedKeys(key);
        this.delegate.addFirst((Object)key, value);
    }

    public List<V> put(String key, List<V> value) {
        this.addToAddedOrUpdatedKeys(key);
        return this.delegate.put((Object)key, value);
    }

    public void putSingle(String key, V value) {
        this.addToAddedOrUpdatedKeys(key);
        this.delegate.putSingle((Object)key, value);
    }

    public boolean replace(String key, List<V> oldValue, List<V> newValue) {
        this.addToAddedOrUpdatedKeys(key);
        return this.delegate.replace((Object)key, oldValue, newValue);
    }

    public List<V> replace(String key, List<V> value) {
        this.addToAddedOrUpdatedKeys(key);
        return (List)this.delegate.replace((Object)key, value);
    }

    public void addAll(String key, List<V> valueList) {
        this.addToAddedOrUpdatedKeys(key);
        this.delegate.addAll((Object)key, valueList);
    }

    public void addAll(String key, V ... newValues) {
        this.addToAddedOrUpdatedKeys(key);
        this.delegate.addAll((Object)key, (Object[])newValues);
    }

    public List<V> merge(String key, List<V> value, BiFunction<? super List<V>, ? super List<V>, ? extends List<V>> remappingFunction) {
        this.addToAddedOrUpdatedKeys(key);
        return (List)this.delegate.merge((Object)key, value, remappingFunction);
    }

    public void putAll(Map<? extends String, ? extends List<V>> t) {
        t.keySet().forEach(this::addToAddedOrUpdatedKeys);
        this.delegate.putAll(t);
    }

    public void replaceAll(BiFunction<? super String, ? super List<V>, ? extends List<V>> function) {
        this.delegate.keySet().forEach(this::addToAddedOrUpdatedKeys);
        this.delegate.replaceAll(function);
    }

    public List<V> putIfAbsent(String key, List<V> value) {
        if (this.delegate.get((Object)key) == null) {
            this.addToAddedOrUpdatedKeys(key);
        }
        return (List)this.delegate.putIfAbsent((Object)key, value);
    }

    public List<V> computeIfAbsent(String key, Function<? super String, ? extends List<V>> mappingFunction) {
        List value = (List)this.delegate.computeIfAbsent((Object)key, mappingFunction);
        if (value != null) {
            this.addToAddedOrUpdatedKeys(key);
        }
        return value;
    }

    public List<V> computeIfPresent(String key, BiFunction<? super String, ? super List<V>, ? extends List<V>> remappingFunction) {
        List value = (List)this.delegate.computeIfPresent((Object)key, remappingFunction);
        if (value != null) {
            this.addToAddedOrUpdatedKeys(key);
        }
        return value;
    }

    public List<V> compute(String key, BiFunction<? super String, ? super List<V>, ? extends List<V>> remappingFunction) {
        List value = (List)this.delegate.compute((Object)key, remappingFunction);
        if (value != null) {
            this.addToAddedOrUpdatedKeys(key);
        }
        return value;
    }

    public List<V> remove(Object key) {
        List value = this.delegate.remove(key);
        if (value != null) {
            this.addToRemovedKeys(key.toString());
        }
        return value;
    }

    public boolean remove(Object key, Object value) {
        if (this.delegate.remove(key, value)) {
            this.addToRemovedKeys(key.toString());
            return true;
        }
        return false;
    }

    public void clear() {
        this.addedOrUpdatedKeys.clear();
        this.delegate.keySet().forEach(this.removedKeys::add);
        this.delegate.clear();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Set<Map.Entry<String, List<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public List<V> get(Object key) {
        return this.delegate.get(key);
    }

    public V getFirst(String key) {
        return (V)this.delegate.getFirst((Object)key);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    public int size() {
        return this.delegate.size();
    }

    public Collection<List<V>> values() {
        return this.delegate.values();
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, V> omap) {
        return this.delegate.equalsIgnoreValueOrder(omap);
    }

    public List<V> getOrDefault(Object key, List<V> defaultValue) {
        return (List)this.delegate.getOrDefault(key, defaultValue);
    }

    public void forEach(BiConsumer<? super String, ? super List<V>> action) {
        this.delegate.forEach(action);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public TrackingMap<V> clone() {
        CaseInsensitiveMap clone = new CaseInsensitiveMap();
        TrackingMap.copy(this.delegate, (MultivaluedMap)clone);
        return new TrackingMap<V>(clone, (Set)((HashSet)this.addedOrUpdatedKeys).clone(), (Set)((HashSet)this.removedKeys).clone());
    }
}

