/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.async;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.jboss.resteasy.microprofile.client.async.AsyncInvocationInterceptorHandler;

public class AsyncInterceptorRxInvoker
implements CompletionStageRxInvoker {
    private final SyncInvoker builder;
    private final ExecutorService executor;

    public AsyncInterceptorRxInvoker(SyncInvoker builder, ExecutorService executor) {
        this.builder = builder;
        this.executor = executor;
    }

    public static <T> CompletionStage<T> whenComplete(CompletionStage<T> stage) {
        Collection<AsyncInvocationInterceptor> asyncInvocationInterceptors = AsyncInvocationInterceptorHandler.threadBoundInterceptors.get();
        AsyncInvocationInterceptorHandler.threadBoundInterceptors.remove();
        return stage.whenComplete((o, throwable) -> {
            if (asyncInvocationInterceptors != null) {
                asyncInvocationInterceptors.forEach(AsyncInvocationInterceptor::removeContext);
            }
        });
    }

    public CompletionStage<Response> get() {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.get()));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.get(), this.executor));
    }

    public <T> CompletionStage<T> get(Class<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.get(responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.get(responseType), this.executor));
    }

    public <T> CompletionStage<T> get(GenericType<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.get(responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.get(responseType), this.executor));
    }

    public CompletionStage<Response> put(Entity<?> entity) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.put(entity)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.put(entity), this.executor));
    }

    public <T> CompletionStage<T> put(Entity<?> entity, Class<T> clazz) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.put(entity, clazz)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.put(entity, clazz), this.executor));
    }

    public <T> CompletionStage<T> put(Entity<?> entity, GenericType<T> type) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.put(entity, type)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.put(entity, type), this.executor));
    }

    public CompletionStage<Response> post(Entity<?> entity) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.post(entity)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.post(entity), this.executor));
    }

    public <T> CompletionStage<T> post(Entity<?> entity, Class<T> clazz) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.post(entity, clazz)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.post(entity, clazz), this.executor));
    }

    public <T> CompletionStage<T> post(Entity<?> entity, GenericType<T> type) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.post(entity, type)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.post(entity, type), this.executor));
    }

    public CompletionStage<Response> delete() {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.delete()));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.delete(), this.executor));
    }

    public <T> CompletionStage<T> delete(Class<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.delete(responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.delete(responseType), this.executor));
    }

    public <T> CompletionStage<T> delete(GenericType<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.delete(responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.delete(responseType), this.executor));
    }

    public CompletionStage<Response> head() {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.head()));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.head(), this.executor));
    }

    public CompletionStage<Response> options() {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.options()));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.options(), this.executor));
    }

    public <T> CompletionStage<T> options(Class<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.options(responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.options(responseType), this.executor));
    }

    public <T> CompletionStage<T> options(GenericType<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.options(responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.options(responseType), this.executor));
    }

    public CompletionStage<Response> trace() {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.trace()));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.trace(), this.executor));
    }

    public <T> CompletionStage<T> trace(Class<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.trace(responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.trace(responseType), this.executor));
    }

    public <T> CompletionStage<T> trace(GenericType<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.trace(responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.trace(responseType), this.executor));
    }

    public CompletionStage<Response> method(String name) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name), this.executor));
    }

    public <T> CompletionStage<T> method(String name, Class<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, responseType), this.executor));
    }

    public <T> CompletionStage<T> method(String name, GenericType<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, responseType), this.executor));
    }

    public CompletionStage<Response> method(String name, Entity<?> entity) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, entity)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, entity), this.executor));
    }

    public <T> CompletionStage<T> method(String name, Entity<?> entity, Class<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, entity, responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, entity, responseType), this.executor));
    }

    public <T> CompletionStage<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, entity, responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method(name, entity, responseType), this.executor));
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public CompletionStage<Response> patch(Entity<?> entity) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method("PATCH", entity)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method("PATCH", entity), this.executor));
    }

    public <T> CompletionStage<T> patch(Entity<?> entity, Class<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method("PATCH", entity, responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method("PATCH", entity, responseType), this.executor));
    }

    public <T> CompletionStage<T> patch(Entity<?> entity, GenericType<T> responseType) {
        if (this.executor == null) {
            return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method("PATCH", entity, responseType)));
        }
        return AsyncInterceptorRxInvoker.whenComplete(CompletableFuture.supplyAsync(() -> this.builder.method("PATCH", entity, responseType), this.executor));
    }
}

