/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.microprofile;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.ReadFromStream;

public class PartialResponse
extends Response
implements Serializable {
    private byte[] bufferedEntity;
    private final transient ClientResponseContext responseContext;

    PartialResponse(ClientResponseContext responseContext) {
        this.responseContext = responseContext;
    }

    public int getStatus() {
        return this.responseContext.getStatus();
    }

    public Response.StatusType getStatusInfo() {
        return this.responseContext.getStatusInfo();
    }

    public Object getEntity() {
        throw this.notSupported();
    }

    private RuntimeException notSupported() {
        RuntimeException ex = new RuntimeException("method call not supported");
        ex.printStackTrace();
        return ex;
    }

    public <T> T readEntity(Class<T> entityType) {
        if (entityType.isAssignableFrom(String.class)) {
            this.bufferEntity();
            return (T)PartialResponse.readStringEntity(new ByteArrayInputStream(this.bufferedEntity));
        }
        throw this.notSupported();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readStringEntity(InputStream input) {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new WebApplicationException("Failed to read entity", (Throwable)e);
        }
    }

    public <T> T readEntity(GenericType<T> entityType) {
        throw this.notSupported();
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        throw this.notSupported();
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        throw this.notSupported();
    }

    public boolean hasEntity() {
        return this.responseContext.hasEntity();
    }

    public synchronized boolean bufferEntity() {
        if (this.bufferedEntity != null) {
            return true;
        }
        InputStream is = this.responseContext.getEntityStream();
        if (is == null) {
            return false;
        }
        try {
            this.bufferedEntity = ReadFromStream.readFromStream((int)1024, (InputStream)is);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        return true;
    }

    public synchronized void close() {
        try {
            this.responseContext.getEntityStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public MediaType getMediaType() {
        return this.responseContext.getMediaType();
    }

    public Locale getLanguage() {
        return this.responseContext.getLanguage();
    }

    public int getLength() {
        return this.responseContext.getLength();
    }

    public Set<String> getAllowedMethods() {
        return this.responseContext.getAllowedMethods();
    }

    public Map<String, NewCookie> getCookies() {
        return this.responseContext.getCookies();
    }

    public EntityTag getEntityTag() {
        return this.responseContext.getEntityTag();
    }

    public Date getDate() {
        return this.responseContext.getDate();
    }

    public Date getLastModified() {
        return this.responseContext.getLastModified();
    }

    public URI getLocation() {
        return this.responseContext.getLocation();
    }

    public Set<Link> getLinks() {
        return this.responseContext.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.responseContext.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.responseContext.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        throw new RuntimeException("method call not supported");
    }

    public MultivaluedMap<String, Object> getMetadata() {
        MultivaluedMapImpl metaData = new MultivaluedMapImpl();
        return metaData;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.responseContext.getHeaders();
    }

    public String getHeaderString(String name) {
        return this.responseContext.getHeaderString(name);
    }
}

