/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.microprofile;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ParamConverterProvider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.microprofile.ConfigurationWrapper;
import org.jboss.resteasy.client.microprofile.DefaultResponseExceptionMapper;
import org.jboss.resteasy.client.microprofile.ExceptionMapping;
import org.jboss.resteasy.client.microprofile.ProxyInvocationHandler;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;

class MicroprofileClientBuilder
implements RestClientBuilder {
    private static final String DEFAULT_MAPPER_PROP = "microprofile.rest.client.disable.default.mapper";
    private final ResteasyClientBuilder builderDelegate;
    private final ConfigurationWrapper configurationWrapper;
    private final Config config;
    private URI baseURI;
    private Set<Object> localProviderInstances = new HashSet<Object>();

    MicroprofileClientBuilder() {
        Config cfg;
        ClientBuilder availableBuilder = ClientBuilder.newBuilder();
        if (availableBuilder instanceof ResteasyClientBuilder) {
            this.builderDelegate = (ResteasyClientBuilder)availableBuilder;
            this.configurationWrapper = new ConfigurationWrapper(this.builderDelegate.getConfiguration());
            cfg = null;
            try {
                ConfigProviderResolver.instance();
                cfg = ConfigProvider.getConfig();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        } else {
            throw new IllegalStateException("Incompatible client builder found " + availableBuilder.getClass());
        }
        this.config = cfg;
    }

    public Configuration getConfigurationWrapper() {
        return this.configurationWrapper;
    }

    public RestClientBuilder baseUrl(URL url) {
        try {
            this.baseURI = url.toURI();
            return this;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public <T> T build(Class<T> aClass) throws IllegalStateException, RestClientDefinitionException {
        RegisterProvider[] providers;
        this.verifyInterface(aClass);
        for (RegisterProvider provider : providers = (RegisterProvider[])aClass.getAnnotationsByType(RegisterProvider.class)) {
            this.register(provider.value(), provider.priority());
        }
        if (!this.isMapperDisabled()) {
            this.register(DefaultResponseExceptionMapper.class);
        }
        this.builderDelegate.register((Object)new ExceptionMapping(this.localProviderInstances), 1);
        ClassLoader classLoader = aClass.getClassLoader();
        List<String> noProxyHosts = Arrays.asList(System.getProperty("http.nonProxyHosts", "localhost|127.*|[::1]").split("|"));
        String proxyHost = System.getProperty("http.proxyHost");
        Object actualClient = proxyHost != null && !noProxyHosts.contains(this.baseURI.getHost()) ? this.builderDelegate.defaultProxy(proxyHost, Integer.parseInt(System.getProperty("http.proxyPort", "80"))).build().target(this.baseURI).proxyBuilder(aClass).classloader(classLoader).defaultConsumes("text/plain").defaultProduces("text/plain").build() : this.builderDelegate.build().target(this.baseURI).proxyBuilder(aClass).classloader(classLoader).defaultConsumes("text/plain").defaultProduces("text/plain").build();
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{aClass}, (InvocationHandler)new ProxyInvocationHandler(actualClient, this.getLocalProviderInstances()));
    }

    private boolean isMapperDisabled() {
        Optional defaultMapperProp;
        boolean disabled = false;
        Optional optional = defaultMapperProp = this.config != null ? this.config.getOptionalValue(DEFAULT_MAPPER_PROP, Boolean.class) : Optional.empty();
        if (defaultMapperProp.isPresent() && ((Boolean)defaultMapperProp.get()).equals(Boolean.TRUE)) {
            disabled = true;
        } else if (!defaultMapperProp.isPresent()) {
            try {
                Object property = this.builderDelegate.getConfiguration().getProperty(DEFAULT_MAPPER_PROP);
                if (property != null) {
                    disabled = (Boolean)property;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return disabled;
    }

    private <T> void verifyInterface(Class<T> typeDef) {
        Method[] methods;
        for (Method method : methods = typeDef.getMethods()) {
            boolean hasHttpMethod = false;
            Annotation[] annotationArray = method.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                boolean isHttpMethod;
                Annotation annotation = annotationArray[i];
                boolean bl = isHttpMethod = annotation.annotationType().getAnnotation(HttpMethod.class) != null;
                if (!hasHttpMethod && isHttpMethod) {
                    hasHttpMethod = true;
                    continue;
                }
                if (!hasHttpMethod || !isHttpMethod) continue;
                throw new RestClientDefinitionException("Ambiguous @Httpmethod defintion on type " + typeDef);
            }
        }
        Path classPathAnno = typeDef.getAnnotation(Path.class);
        HashSet classLevelVariables = new HashSet();
        ResteasyUriBuilder classTemplate = null;
        if (classPathAnno != null) {
            classTemplate = (ResteasyUriBuilder)UriBuilder.fromUri((String)classPathAnno.value());
            classLevelVariables.addAll(classTemplate.getPathParamNamesInDeclarationOrder());
        }
        for (Method method : methods) {
            Path methodPathAnno = method.getAnnotation(Path.class);
            ResteasyUriBuilder template = methodPathAnno != null ? (classPathAnno == null ? (ResteasyUriBuilder)UriBuilder.fromUri((String)methodPathAnno.value()) : (ResteasyUriBuilder)UriBuilder.fromUri((String)(classPathAnno.value() + "/" + methodPathAnno.value()))) : classTemplate;
            if (template == null) continue;
            template.host("localhost");
            HashSet allVariables = new HashSet(template.getPathParamNamesInDeclarationOrder());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (Parameter p : method.getParameters()) {
                PathParam pathParam = p.getAnnotation(PathParam.class);
                if (pathParam == null) continue;
                paramMap.put(pathParam.value(), "foobar");
            }
            if (allVariables.size() != paramMap.size()) {
                throw new RestClientDefinitionException("Parameters and variables don't match on " + typeDef + "::" + method.getName());
            }
            try {
                template.resolveTemplates(paramMap, false).build(new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                throw new RestClientDefinitionException("Parameter names don't match variable names on " + typeDef + "::" + method.getName(), (Throwable)ex);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.getConfigurationWrapper();
    }

    public RestClientBuilder property(String name, Object value) {
        this.builderDelegate.property(name, value);
        return this;
    }

    private static Object newInstanceOf(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to register " + clazz, t);
        }
    }

    public RestClientBuilder register(Class<?> aClass) {
        this.register(MicroprofileClientBuilder.newInstanceOf(aClass));
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, int i) {
        this.register(MicroprofileClientBuilder.newInstanceOf(aClass), i);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, Class<?>[] classes) {
        this.register(MicroprofileClientBuilder.newInstanceOf(aClass), classes);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, Map<Class<?>, Integer> map) {
        this.register(MicroprofileClientBuilder.newInstanceOf(aClass), map);
        return this;
    }

    public RestClientBuilder register(Object o) {
        if (o instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)o;
            this.register((Object)mapper, mapper.getPriority());
        } else if (o instanceof ParamConverterProvider) {
            this.register(o, 5000);
        } else {
            this.builderDelegate.register(o);
        }
        return this;
    }

    public RestClientBuilder register(Object o, int i) {
        if (o instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)o;
            HashMap contracts = new HashMap();
            contracts.put(ResponseExceptionMapper.class, i);
            this.registerLocalProviderInstance(mapper, contracts);
            this.builderDelegate.register((Object)mapper, i);
        } else if (o instanceof ParamConverterProvider) {
            ParamConverterProvider converter = (ParamConverterProvider)o;
            HashMap contracts = new HashMap();
            contracts.put(ParamConverterProvider.class, i);
            this.registerLocalProviderInstance(converter, contracts);
            this.builderDelegate.register((Object)converter, i);
        } else {
            this.builderDelegate.register(o, i);
        }
        return this;
    }

    public RestClientBuilder register(Object o, Class<?>[] classes) {
        for (Class<ResponseExceptionMapper> clazz : classes) {
            if (!clazz.isAssignableFrom(ResponseExceptionMapper.class)) continue;
            this.register(o);
        }
        this.builderDelegate.register(o, (Class[])classes);
        return this;
    }

    public RestClientBuilder register(Object o, Map<Class<?>, Integer> map) {
        if (o instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)o;
            HashMap contracts = new HashMap();
            contracts.put(ResponseExceptionMapper.class, map.get(ResponseExceptionMapper.class));
            this.registerLocalProviderInstance(mapper, contracts);
            this.builderDelegate.register(o, map);
        } else {
            this.builderDelegate.register(o, map);
        }
        return this;
    }

    public Set<Object> getLocalProviderInstances() {
        return this.localProviderInstances;
    }

    public void registerLocalProviderInstance(Object provider, Map<Class<?>, Integer> contracts) {
        for (Object registered : this.getLocalProviderInstances()) {
            if (registered != provider) continue;
            System.out.println("Provider already registered " + provider.getClass().getName());
            return;
        }
        this.localProviderInstances.add(provider);
        this.configurationWrapper.registerLocalContract(provider.getClass(), contracts);
    }
}

