/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.impl;

import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestContextImpl;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.microprofile.client.async.ExecutorServiceWrapper;

public class MpClientInvocation
extends ClientInvocation {
    public static final String CONTAINER_HEADERS = "MP_CLIENT_CONTAINER_HEADERS";
    private MultivaluedMap<String, String> containerHeaders;
    private List<AsyncInvocationInterceptor> asyncInvocationInterceptors;
    private ExecutorService invocationExecutor;

    protected MpClientInvocation(ClientInvocation clientInvocation, List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories) {
        super(clientInvocation);
        this.captureContainerHeaders();
        this.captureContext(asyncInterceptorFactories);
    }

    protected MpClientInvocation(ResteasyClient client, URI uri, ClientRequestHeaders headers, ClientConfiguration parent, List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories) {
        super(client, uri, headers, parent);
        this.captureContainerHeaders();
        this.captureContext(asyncInterceptorFactories);
    }

    private void captureContext(List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories) {
        if (asyncInterceptorFactories != null) {
            this.asyncInvocationInterceptors = asyncInterceptorFactories.stream().map(AsyncInvocationInterceptorFactory::newInterceptor).collect(Collectors.toList());
            this.asyncInvocationInterceptors.forEach(AsyncInvocationInterceptor::prepareContext);
            this.invocationExecutor = new ExecutorServiceWrapper(this.client.asyncInvocationExecutor(), new Decorator(this.asyncInvocationInterceptors));
        } else {
            this.invocationExecutor = this.client.asyncInvocationExecutor();
        }
    }

    public ExecutorService asyncInvocationExecutor() {
        return this.invocationExecutor;
    }

    private void captureContainerHeaders() {
        HttpHeaders containerHeaders = (HttpHeaders)ResteasyContext.getContextData(HttpHeaders.class);
        if (containerHeaders != null) {
            this.containerHeaders = containerHeaders.getRequestHeaders();
        }
    }

    protected ClientResponse filterRequest(ClientRequestContextImpl requestContext) {
        if (this.containerHeaders != null) {
            requestContext.setProperty(CONTAINER_HEADERS, this.containerHeaders);
        }
        return super.filterRequest(requestContext);
    }

    public static class Decorator
    implements ExecutorServiceWrapper.Decorator {
        private List<AsyncInvocationInterceptor> asyncInvocationInterceptors;

        public Decorator(List<AsyncInvocationInterceptor> asyncInvocationInterceptors) {
            this.asyncInvocationInterceptors = asyncInvocationInterceptors;
        }

        @Override
        public Runnable decorate(Runnable runnable) {
            return () -> {
                if (this.asyncInvocationInterceptors != null) {
                    this.asyncInvocationInterceptors.forEach(AsyncInvocationInterceptor::applyContext);
                }
                try {
                    runnable.run();
                }
                finally {
                    if (this.asyncInvocationInterceptors != null) {
                        this.asyncInvocationInterceptors.forEach(AsyncInvocationInterceptor::removeContext);
                    }
                }
            };
        }

        public <V> Callable<V> decorate(Callable<V> callable) {
            return () -> {
                if (this.asyncInvocationInterceptors != null) {
                    this.asyncInvocationInterceptors.forEach(AsyncInvocationInterceptor::applyContext);
                }
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    if (this.asyncInvocationInterceptors != null) {
                        this.asyncInvocationInterceptors.forEach(AsyncInvocationInterceptor::removeContext);
                    }
                }
            };
        }
    }
}

