/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines.jetty;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.ByteBufferPool;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.AsyncClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.jetty.JettyClientResponse;
import org.jboss.resteasy.client.jaxrs.engines.jetty.JettyResponseStream;
import org.jboss.resteasy.client.jaxrs.engines.jetty.ReleaseCallback;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;

public class JettyClientEngine
implements AsyncClientHttpEngine {
    private static final AtomicBoolean WARN_BUF = new AtomicBoolean();
    public static final String REQUEST_TIMEOUT_MS = JettyClientEngine.class + "$RequestTimeout";
    public static final String FOLLOW_REDIRECTS = "jersey.config.client.followRedirects";
    private static final InvocationCallback<ClientResponse> NOP = new InvocationCallback<ClientResponse>(){

        public void completed(ClientResponse response) {
        }

        public void failed(Throwable throwable) {
        }
    };
    private final HttpClient client;

    public JettyClientEngine(HttpClient client) {
        if (!client.isStarted()) {
            try {
                client.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.client = client;
    }

    public SSLContext getSslContext() {
        return this.client.getSslContextFactory().getSslContext();
    }

    public HostnameVerifier getHostnameVerifier() {
        throw new UnsupportedOperationException();
    }

    public ClientResponse invoke(ClientInvocation invocation) {
        Future<ClientResponse> future = this.submit(invocation, true, NOP, null);
        try {
            return future.get(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            Thread.currentThread().interrupt();
            throw JettyClientEngine.clientException(e, null);
        }
        catch (ExecutionException | TimeoutException e) {
            future.cancel(true);
            throw JettyClientEngine.clientException(e.getCause(), null);
        }
    }

    public <T> Future<T> submit(final ClientInvocation invocation, boolean bufIn, final InvocationCallback<T> callback, final AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        boolean buffered;
        if (!bufIn && extractor != null) {
            if (!WARN_BUF.getAndSet(true)) {
                Logger LOG = Logger.getLogger(JettyClientEngine.class);
                LOG.error((Object)"TODO: ResultExtractor is synchronous and may not be used without buffering - forcing buffer mode.");
            }
            buffered = true;
        } else {
            buffered = bufIn;
        }
        Request request = this.client.newRequest(invocation.getUri());
        final RequestFuture future = new RequestFuture(request);
        final AtomicBoolean completing = new AtomicBoolean();
        invocation.getMutableProperties().forEach((arg_0, arg_1) -> ((Request)request).attribute(arg_0, arg_1));
        request.method(invocation.getMethod());
        invocation.getHeaders().asMap().forEach((h, vs) -> vs.forEach(v -> request.header(h, v)));
        this.configureTimeout(request);
        if (request.getAttributes().get(FOLLOW_REDIRECTS) == Boolean.FALSE) {
            request.followRedirects(false);
        }
        if (invocation.getEntity() != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                invocation.writeRequestBody((OutputStream)os);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
                if (callback != null) {
                    callback.failed((Throwable)e);
                }
                return future;
            }
            request.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{os.toByteArray()}));
        }
        request.send((Response.CompleteListener)new Response.Listener.Adapter(){
            private ClientResponse cr;
            private JettyResponseStream stream = new JettyResponseStream();

            public void onHeaders(org.eclipse.jetty.client.api.Response response) {
                this.cr = new JettyClientResponse(invocation.getClientConfiguration(), this.stream, () -> {
                    if (!completing.get()) {
                        future.cancel(true);
                    }
                });
                this.cr.setProperties(invocation.getMutableProperties());
                this.cr.setStatus(response.getStatus());
                this.cr.setHeaders(JettyClientEngine.this.extract(response.getHeaders()));
                if (!buffered) {
                    this.complete();
                }
            }

            public void onContent(org.eclipse.jetty.client.api.Response response, ByteBuffer buf) {
                ByteBufferPool bufs = JettyClientEngine.this.client.getByteBufferPool();
                ByteBuffer copy = bufs.acquire(buf.remaining(), false);
                copy.limit(buf.remaining());
                copy.put(buf);
                copy.flip();
                this.stream.offer(copy, new ReleaseCallback(bufs, copy));
            }

            public void onSuccess(org.eclipse.jetty.client.api.Response response) {
                if (buffered) {
                    try {
                        this.complete();
                    }
                    catch (Exception e) {
                        this.onFailure(response, e);
                    }
                }
            }

            private void complete() {
                completing.set(true);
                if (buffered) {
                    this.cr.bufferEntity();
                }
                this.complete(extractor == null ? this.cr : extractor.extractResult(this.cr));
            }

            public void onFailure(org.eclipse.jetty.client.api.Response response, Throwable failure) {
                this.failed(failure);
            }

            public void onComplete(Result result) {
                try {
                    if (extractor != null) {
                        this.stream.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            private void complete(T result) {
                future.complete(result);
                if (callback != null) {
                    callback.completed(result);
                }
            }

            private void failed(Throwable t) {
                RuntimeException x = JettyClientEngine.clientException(t, (Response)this.cr);
                future.completeExceptionally(x);
                if (callback != null) {
                    callback.failed((Throwable)x);
                }
            }
        });
        return future;
    }

    private void configureTimeout(Request request) {
        Object timeout = request.getAttributes().get(REQUEST_TIMEOUT_MS);
        long timeoutMs = timeout instanceof Duration ? ((Duration)timeout).toMillis() : (timeout instanceof Number ? (long)((Number)timeout).intValue() : (timeout != null ? (long)Integer.parseInt(timeout.toString()) : -1L));
        if (timeoutMs > 0L) {
            request.timeout(timeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    public void close() {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to close JettyHttpEngine", e);
        }
    }

    MultivaluedMap<String, String> extract(HttpFields headers) {
        MultivaluedHashMap extracted = new MultivaluedHashMap();
        headers.forEach(arg_0 -> JettyClientEngine.lambda$extract$2((MultivaluedMap)extracted, arg_0));
        return extracted;
    }

    private static RuntimeException clientException(Throwable ex, Response clientResponse) {
        Object ret;
        if (ex == null) {
            NullPointerException e = new NullPointerException();
            e.fillInStackTrace();
            ret = new ProcessingException((Throwable)e);
        } else {
            ret = ex instanceof WebApplicationException ? (WebApplicationException)ex : (ex instanceof ProcessingException ? (ProcessingException)ex : (clientResponse != null ? new ResponseProcessingException(clientResponse, ex) : new ProcessingException(ex)));
        }
        ret.fillInStackTrace();
        return ret;
    }

    private static /* synthetic */ void lambda$extract$2(MultivaluedMap extracted, HttpField h) {
        extracted.add((Object)h.getName(), (Object)h.getValue());
    }

    static class RequestFuture<T>
    extends CompletableFuture<T> {
        private final Request request;

        RequestFuture(Request request) {
            this.request = request;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (mayInterruptIfRunning && cancelled) {
                this.request.abort((Throwable)new CancellationException());
            }
            return cancelled;
        }
    }
}

