/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.interceptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.interceptors.Book;
import org.jboss.resteasy.cdi.interceptors.BookReaderInterceptor;
import org.jboss.resteasy.cdi.interceptors.BookReaderInterceptorInterceptor;
import org.jboss.resteasy.cdi.interceptors.BookWriterInterceptor;
import org.jboss.resteasy.cdi.interceptors.BookWriterInterceptorInterceptor;
import org.jboss.resteasy.cdi.interceptors.ClassBinding;
import org.jboss.resteasy.cdi.interceptors.FilterBinding;
import org.jboss.resteasy.cdi.interceptors.Interceptor0;
import org.jboss.resteasy.cdi.interceptors.Interceptor1;
import org.jboss.resteasy.cdi.interceptors.Interceptor2;
import org.jboss.resteasy.cdi.interceptors.Interceptor3;
import org.jboss.resteasy.cdi.interceptors.LifecycleBinding;
import org.jboss.resteasy.cdi.interceptors.MethodBinding;
import org.jboss.resteasy.cdi.interceptors.PostConstructInterceptor;
import org.jboss.resteasy.cdi.interceptors.PreDestroyInterceptor;
import org.jboss.resteasy.cdi.interceptors.RequestFilterInterceptor;
import org.jboss.resteasy.cdi.interceptors.ResponseFilterInterceptor;
import org.jboss.resteasy.cdi.interceptors.Stereotyped;
import org.jboss.resteasy.cdi.interceptors.VisitList;

@Path(value="/")
@RequestScoped
@Interceptors(value={Interceptor0.class})
@ClassBinding
@LifecycleBinding
public class InterceptorResource {
    private static Map<Integer, Book> collection = new HashMap<Integer, Book>();
    private static AtomicInteger counter = new AtomicInteger();
    @Inject
    private Logger log;
    @Inject
    private Stereotyped stereotyped;

    @PostConstruct
    public void postConstruct() {
        this.log.info("executing InterceptorResource.postConstruct()");
    }

    @PreDestroy
    public void PreDestroy() {
        this.log.info("executing InterceptorResource.PreDestroy()");
    }

    @POST
    @Path(value="create")
    @Consumes(value={"application/test+xml"})
    @Produces(value={"text/plain"})
    @Interceptors(value={Interceptor1.class})
    @MethodBinding
    @FilterBinding
    public Response createBook(Book book) {
        this.log.info("entering InterceptorResource.createBook()");
        int id = counter.getAndIncrement();
        book.setId(id);
        collection.put(id, book);
        this.log.info("stored: " + id + "->" + book);
        this.log.info("leaving InterceptorResource.createBook()");
        return Response.ok((Object)id).build();
    }

    @GET
    @Path(value="book/{id:[0-9][0-9]*}")
    @Produces(value={"application/test+xml"})
    @Interceptors(value={Interceptor1.class})
    @MethodBinding
    @FilterBinding
    public Book lookupBookById(@PathParam(value="id") int id) {
        this.log.info("entering InterceptorResource.lookupBookById(" + id + ")");
        this.log.info("books: " + collection);
        Book book = collection.get(id);
        if (book == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.log.info("leaving InterceptorResource.lookupBookById(" + id + ")");
        return book;
    }

    @POST
    @Path(value="test")
    @Produces(value={"text/plain"})
    @Interceptors(value={Interceptor1.class})
    @MethodBinding
    public Response test() {
        int i;
        boolean status;
        this.log.info("entering InterceptorResource.test()");
        this.stereotyped.test();
        ArrayList<Class<Interceptor3>> expectedList = new ArrayList<Class<Interceptor3>>();
        expectedList.add(RequestFilterInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(BookReaderInterceptorInterceptor.class);
        expectedList.add(BookReaderInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor1.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(Interceptor3.class);
        expectedList.add(PostConstructInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor1.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(Interceptor3.class);
        expectedList.add(ResponseFilterInterceptor.class);
        expectedList.add(BookWriterInterceptorInterceptor.class);
        expectedList.add(BookWriterInterceptor.class);
        expectedList.add(PreDestroyInterceptor.class);
        expectedList.add(RequestFilterInterceptor.class);
        expectedList.add(PostConstructInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor1.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(Interceptor3.class);
        expectedList.add(ResponseFilterInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(BookWriterInterceptorInterceptor.class);
        expectedList.add(BookWriterInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor1.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(Interceptor3.class);
        expectedList.add(PreDestroyInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(BookReaderInterceptorInterceptor.class);
        expectedList.add(BookReaderInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor1.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(Interceptor3.class);
        expectedList.add(PostConstructInterceptor.class);
        expectedList.add(Interceptor0.class);
        expectedList.add(Interceptor1.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(Interceptor3.class);
        expectedList.add(Interceptor2.class);
        expectedList.add(Interceptor3.class);
        ArrayList<Object> visitList = VisitList.getList();
        boolean bl = status = expectedList.size() == visitList.size();
        if (!status) {
            this.log.info("expectedList.size() [" + expectedList.size() + "] != visitList.size() [" + visitList.size() + "]");
        }
        for (i = 0; i < expectedList.size(); ++i) {
            if (((Class)expectedList.get(i)).isAssignableFrom(visitList.get(i).getClass())) continue;
            status = false;
            this.log.info("visitList.get(" + i + ") incorrect: should be an instance of: " + expectedList.get(i) + ", is: " + visitList.get(i));
            break;
        }
        if (!status) {
            this.log.info("\rexpected list:");
            for (i = 0; i < expectedList.size(); ++i) {
                this.log.info(i + ": " + ((Class)expectedList.get(i)).toString());
            }
            this.log.info("\rvisited list:");
            for (i = 0; i < visitList.size(); ++i) {
                this.log.info(i + ": " + visitList.get(i).toString());
            }
        }
        this.log.info("leaving InterceptorResource.test()");
        return status ? Response.ok().build() : Response.serverError().build();
    }
}

