/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.events.ejb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.events.ejb.Book;
import org.jboss.resteasy.cdi.events.ejb.EventObserver;
import org.jboss.resteasy.cdi.events.ejb.EventSource;
import org.jboss.resteasy.cdi.events.ejb.Process;
import org.jboss.resteasy.cdi.events.ejb.Read;
import org.jboss.resteasy.cdi.events.ejb.Write;

@Stateless
public class EventSourceImpl
implements EventSource {
    private static Map<Integer, Book> collection = new HashMap<Integer, Book>();
    private static AtomicInteger counter = new AtomicInteger();
    @Inject
    @Process
    Event<String> processEvent;
    @Inject
    @Read(context="resource")
    @Process
    Event<String> readProcessEvent;
    @Inject
    @Write(context="resource")
    @Process
    Event<String> writeProcessEvent;
    @Inject
    EventObserver eventObserver;
    @Inject
    private Logger log;

    @Override
    public boolean test() {
        this.log.info("entering EventSourceImpl.test()");
        ArrayList<Object> eventList = this.eventObserver.getEventList();
        for (int i = 0; i < eventList.size(); ++i) {
            this.log.info(eventList.get(i).toString());
        }
        this.log.info("leaving EventSourceImpl.test()");
        return true;
    }

    @Override
    public int createBook(Book book) {
        this.log.info("entering EventSourceImpl.createBook()");
        this.log.info("EventSourceImpl firing processEvent");
        this.processEvent.fire((Object)"processEvent");
        int id = counter.getAndIncrement();
        book.setId(id);
        collection.put(id, book);
        this.log.info("stored: " + id + "->" + book);
        this.log.info("EventSourceImpl firing readProcessEvent");
        this.readProcessEvent.fire((Object)"readProcessEvent");
        this.log.info("leaving EventSourceImpl.createBook()");
        return id;
    }

    @Override
    public Book lookupBookById(@PathParam(value="id") int id) {
        this.log.info("entering EventSourceImpl.lookupBookById(" + id + ")");
        this.log.info("books: " + collection);
        this.log.info("EventSourceImpl firing processEvent");
        this.processEvent.fire((Object)"processEvent");
        Book book = collection.get(id);
        this.log.info("EventSourceImpl firing writeProcessEvent");
        this.writeProcessEvent.fire((Object)"writeProcessEvent");
        if (book == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.log.info("leaving EventSourceImpl.lookupBookById(" + id + ")");
        return book;
    }
}

