/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.decorators;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.cdi.decorators.Book;
import org.jboss.resteasy.cdi.decorators.VisitList;

@Decorator
public abstract class BookWriterDecorator
implements MessageBodyWriter<Book> {
    @Inject
    private Logger log;
    @Inject
    @Delegate
    private MessageBodyWriter<Book> writer;

    public void writeTo(Book t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.log.info("entering BookWriterDecorator.writeTo()");
        VisitList.add("writerDecoratorEnter");
        this.writer.writeTo((Object)t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
        VisitList.add("writerDecoratorLeave");
        this.log.info("leaving BookWriterDecorator.writeTo()");
    }
}

