/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.asynch;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.asynch.AsynchronousStatelessLocal;

@Stateless
@Path(value="/")
public class AsynchronousResource {
    @Inject
    private Logger log;
    @Inject
    private AsynchronousStatelessLocal stateless;

    @GET
    @Path(value="asynch/simple")
    public Response asynchSimple() throws ExecutionException, InterruptedException {
        this.log.info("entering asynch()");
        Future<Boolean> asyncResult = this.stateless.asynch();
        return asyncResult.get() != false ? Response.ok().build() : Response.serverError().build();
    }

    @GET
    @Path(value="asynch/asynch")
    public void asynchAsynch(@Suspended AsyncResponse asyncResponse) throws ExecutionException, InterruptedException {
        this.log.info("entering asynchAsynch()");
        Future<Boolean> asyncResult = this.stateless.asynch();
        Response response = asyncResult.get() != false ? Response.ok().build() : Response.serverError().build();
        Thread.sleep(2000L);
        asyncResponse.resume((Object)response);
    }

    @Asynchronous
    @GET
    @Path(value="asynch/ejb")
    public void asynchEJB(@Suspended AsyncResponse asyncResponse) throws ExecutionException, InterruptedException {
        this.log.info("entering asynchEJB()");
        Thread.sleep(2000L);
        asyncResponse.resume((Object)Response.ok().build());
    }
}

