/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import se.unlogic.standardutils.dao.Column;
import se.unlogic.standardutils.populators.QueryParameterPopulator;

public class SimpleColumn<BeanType, ColumnType>
implements Column<BeanType, ColumnType> {
    private final Field beanField;
    private final Method queryMethod;
    private final QueryParameterPopulator<?> queryParameterPopulator;
    private final String columnName;
    private final boolean autoGenerated;

    public SimpleColumn(Field beanField, Method queryMethod, QueryParameterPopulator<?> queryPopulator, String columnName, boolean autoGenerated) {
        this.beanField = beanField;
        this.queryMethod = queryMethod;
        this.columnName = columnName;
        this.autoGenerated = autoGenerated;
        this.queryParameterPopulator = queryPopulator;
    }

    @Override
    public ColumnType getParamValue(Object paramValue) {
        return (ColumnType)paramValue;
    }

    @Override
    public ColumnType getBeanValue(BeanType bean) {
        try {
            return (ColumnType)this.beanField.get(bean);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Field getBeanField() {
        return this.beanField;
    }

    @Override
    public Class<?> getParamType() {
        return this.beanField.getType();
    }

    @Override
    public Method getQueryMethod() {
        return this.queryMethod;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    @Override
    public QueryParameterPopulator<?> getQueryParameterPopulator() {
        return this.queryParameterPopulator;
    }

    public static <BT, CT> SimpleColumn<BT, CT> getGenericInstance(Class<BT> beanClass, Class<CT> fieldClass, Field beanField, Method queryMethod, QueryParameterPopulator<?> queryPopulator, String columnName, boolean autoGenerated) {
        return new SimpleColumn(beanField, queryMethod, queryPopulator, columnName, autoGenerated);
    }
}

