/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.Column;
import se.unlogic.standardutils.dao.MethodBasedResultSetPopulator;
import se.unlogic.standardutils.dao.OneToManyRelation;
import se.unlogic.standardutils.dao.PreparedStatementQueryMethods;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.ResultSetMethods;
import se.unlogic.standardutils.dao.TypeBasedResultSetPopulator;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.dao.enums.Order;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.PreparedStatementQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.StringUtils;

public class SimplifiedOneToManyRelation<LocalType, RemoteType>
implements OneToManyRelation<LocalType, RemoteType> {
    private final AnnotatedDAO<LocalType> localDAO;
    private final Field field;
    private String selectSQL;
    private String insertSQL;
    private String deleteSQL;
    private boolean preserveListOrder;
    private String indexColumnName;
    private QueryParameterPopulator<RemoteType> queryParameterPopulator;
    private Method preparedStatementMethod;
    private BeanResultSetPopulator<RemoteType> beanResultSetPopulator;
    private Field keyField;
    private Column<LocalType, ?> keyColumn;
    private final String remoteTableName;
    private String remoteKeyColumnName;
    private final String remoteValueColumnName;
    private Order order;
    private boolean initialized;

    public SimplifiedOneToManyRelation(Class<LocalType> beanClass, Class<RemoteType> remoteClass, Field field, AnnotatedDAO<LocalType> localDAO, List<? extends BeanStringPopulator<?>> typePopulators, List<? extends QueryParameterPopulator<?>> queryParameterPopulators) {
        SimplifiedRelation simplifiedRelation;
        block17: {
            this.localDAO = localDAO;
            this.field = field;
            simplifiedRelation = field.getAnnotation(SimplifiedRelation.class);
            this.remoteKeyColumnName = simplifiedRelation.remoteKeyColumnName();
            this.remoteValueColumnName = simplifiedRelation.remoteValueColumnName();
            this.order = simplifiedRelation.order();
            this.remoteTableName = simplifiedRelation.addTablePrefix() ? (simplifiedRelation.deplurifyTablePrefix() && localDAO.getTableName().endsWith("s") ? localDAO.getTableName().substring(0, localDAO.getTableName().length() - 1) + simplifiedRelation.table() : localDAO.getTableName() + simplifiedRelation.table()) : simplifiedRelation.table();
            if (!StringUtils.isEmpty(simplifiedRelation.keyField())) {
                try {
                    this.keyField = ReflectionUtils.getField(beanClass, simplifiedRelation.keyField());
                    if (this.keyField == null) {
                        throw new RuntimeException("Unable to find field " + simplifiedRelation.keyField() + " in " + beanClass.getClass());
                    }
                    break block17;
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            List<Field> fields = ReflectionUtils.getFields(beanClass);
            for (Field localBeanField : fields) {
                if (!localBeanField.isAnnotationPresent(DAOManaged.class) || !localBeanField.isAnnotationPresent(Key.class)) continue;
                if (this.keyField == null) {
                    this.keyField = localBeanField;
                    continue;
                }
                throw new RuntimeException("Multiple fields marked with @Key annotation found in class " + beanClass + " therefore keyField has to set on the @SimplifiedRelation annotation of field " + field.getName());
            }
        }
        if (queryParameterPopulators != null) {
            for (QueryParameterPopulator<?> queryParameterPopulator : queryParameterPopulators) {
                if (!queryParameterPopulator.getType().equals(remoteClass)) continue;
                this.queryParameterPopulator = queryParameterPopulator;
            }
        }
        if (this.queryParameterPopulator == null) {
            this.preparedStatementMethod = PreparedStatementQueryMethods.getQueryMethod(remoteClass);
            if (this.preparedStatementMethod == null) {
                throw new RuntimeException("Unable to to find a query parameter populator or prepared statement method matching " + remoteClass + " of @SimplfiedRelation and @OneToMany annotated field " + field.getName() + " in " + beanClass);
            }
        }
        if (typePopulators != null) {
            for (BeanStringPopulator beanStringPopulator : typePopulators) {
                if (!beanStringPopulator.getType().equals(remoteClass)) continue;
                this.beanResultSetPopulator = new TypeBasedResultSetPopulator<RemoteType>(beanStringPopulator, this.remoteValueColumnName);
            }
        }
        if (this.beanResultSetPopulator == null) {
            Method resultSetMethod = ResultSetMethods.getColumnNameMethod(remoteClass);
            if (resultSetMethod != null) {
                this.beanResultSetPopulator = new MethodBasedResultSetPopulator<RemoteType>(resultSetMethod, this.remoteValueColumnName);
            } else {
                throw new RuntimeException("Unable to to find a type populator or resultset method matching " + remoteClass + " of @SimplfiedRelation and @OneToMany annotated field " + field.getName() + " in " + beanClass);
            }
        }
        if (simplifiedRelation.preserveListOrder()) {
            if (StringUtils.isEmpty(simplifiedRelation.indexColumn())) {
                throw new RuntimeException("Preserve list order enabled but no index column specified for @SimplifiedRelation annotated field " + field.getName() + " in " + beanClass);
            }
            this.preserveListOrder = true;
            this.indexColumnName = simplifiedRelation.indexColumn();
        }
    }

    private void init() {
        this.keyColumn = this.localDAO.getColumn(this.keyField);
        if (StringUtils.isEmpty(this.remoteKeyColumnName)) {
            this.remoteKeyColumnName = this.keyColumn.getColumnName();
        }
        this.deleteSQL = "DELETE FROM " + this.remoteTableName + " WHERE " + this.remoteKeyColumnName + "=?";
        if (this.preserveListOrder) {
            this.selectSQL = "SELECT * FROM " + this.remoteTableName + " WHERE " + this.remoteKeyColumnName + " = ? ORDER BY " + this.indexColumnName + " " + (Object)((Object)this.order);
            this.insertSQL = "INSERT INTO " + this.remoteTableName + "(" + this.remoteKeyColumnName + "," + this.remoteValueColumnName + "," + this.indexColumnName + ") VALUES (?,?,?)";
        } else {
            this.selectSQL = "SELECT * FROM " + this.remoteTableName + " WHERE " + this.remoteKeyColumnName + " = ? ORDER BY " + this.remoteValueColumnName + " " + (Object)((Object)this.order);
            this.insertSQL = "INSERT INTO " + this.remoteTableName + "(" + this.remoteKeyColumnName + "," + this.remoteValueColumnName + ") VALUES (?,?)";
        }
        this.initialized = true;
    }

    @Override
    public void getRemoteValue(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            ArrayListQuery<RemoteType> query = new ArrayListQuery<RemoteType>(connection, false, this.selectSQL, this.beanResultSetPopulator);
            this.setKey(query, bean);
            ArrayList<RemoteType> list = query.executeQuery();
            if (list != null) {
                CollectionUtils.removeNullValues(list);
            }
            this.field.set(bean, list);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setKey(PreparedStatementQuery query, LocalType bean) throws SQLException {
        if (this.keyColumn.getQueryParameterPopulator() != null) {
            this.keyColumn.getQueryParameterPopulator().populate(query, 1, bean);
        } else {
            try {
                this.keyColumn.getQueryMethod().invoke((Object)query, 1, this.keyColumn.getBeanValue(bean));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setValue(RemoteType value, UpdateQuery query) throws SQLException {
        if (this.queryParameterPopulator != null) {
            this.queryParameterPopulator.populate(query, 2, value);
        } else {
            try {
                this.preparedStatementMethod.invoke((Object)query, 2, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void add(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            List values = (List)this.field.get(bean);
            if (values != null) {
                int listIndex = 0;
                for (Object value : values) {
                    UpdateQuery query = new UpdateQuery(connection, false, this.insertSQL);
                    this.setKey(query, bean);
                    this.setValue(value, query);
                    if (this.preserveListOrder) {
                        query.setInt(3, listIndex);
                        ++listIndex;
                    }
                    query.executeUpdate();
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        UpdateQuery query = new UpdateQuery(connection, false, this.deleteSQL);
        this.setKey(query, bean);
        query.executeUpdate();
        this.add(bean, connection, relationQuery);
    }

    public static <LT, RT> OneToManyRelation<LT, RT> getGenericInstance(Class<LT> beanClass, Class<RT> remoteClass, Field field, AnnotatedDAO<LT> localDAO, List<? extends BeanStringPopulator<?>> typePopulators, List<? extends QueryParameterPopulator<?>> queryParameterPopulators) {
        return new SimplifiedOneToManyRelation<LT, RT>(beanClass, remoteClass, field, localDAO, typePopulators, queryParameterPopulators);
    }
}

