/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.junit.Assert;

public final class PermissionUtil {
    public static Asset createPermissionsXmlAsset(Permission ... permissions) {
        return new StringAsset(new String(PermissionUtil.createPermissionsXml(permissions), StandardCharsets.UTF_8));
    }

    public static Asset createPermissionsXmlAsset(Iterable<? extends Permission> permissions, Permission ... additionalPermissions) {
        return new StringAsset(new String(PermissionUtil.createPermissionsXml(permissions, additionalPermissions), StandardCharsets.UTF_8));
    }

    public static Asset createPermissionsXmlAsset(Iterable<? extends Permission> permissions) {
        return new StringAsset(new String(PermissionUtil.createPermissionsXml(permissions, new Permission[0]), StandardCharsets.UTF_8));
    }

    public static byte[] createPermissionsXml(Permission ... permissions) {
        return PermissionUtil.createPermissionsXml(Arrays.asList(permissions), new Permission[0]);
    }

    public static byte[] createPermissionsXml(Iterable<? extends Permission> permissions, Permission ... additionalPermissions) {
        byte[] byArray;
        Element permissionsElement = new Element("permissions");
        permissionsElement.setNamespaceURI("http://xmlns.jcp.org/xml/ns/javaee");
        permissionsElement.addAttribute(new Attribute("version", "7"));
        PermissionUtil.addPermissionXml(permissionsElement, permissions);
        if (additionalPermissions != null && additionalPermissions.length > 0) {
            PermissionUtil.addPermissionXml(permissionsElement, Arrays.asList(additionalPermissions));
        }
        Document document = new Document(permissionsElement);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            NiceSerializer serializer = new NiceSerializer(stream);
            serializer.setIndent(4);
            serializer.setLineSeparator("\n");
            serializer.write(document);
            serializer.flush();
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Generating permissions.xml failed", e);
            }
        }
        stream.close();
        return byArray;
    }

    public static Collection<Permission> addModuleFilePermission(String ... moduleNames) {
        String value = System.getProperty("module.jar.path");
        if (value == null || value.isBlank()) {
            return Collections.emptySet();
        }
        Path moduleDir = Path.of(value, new String[0]);
        ArrayList<Permission> result = new ArrayList<Permission>();
        for (String moduleName : moduleNames) {
            Path definedModuleDir = moduleDir.resolve(moduleName.replace('.', File.separatorChar)).resolve("main");
            try (Stream<Path> stream = Files.walk(definedModuleDir, new FileVisitOption[0]);){
                stream.filter(path -> path.getFileName().toString().endsWith(".jar")).map(path -> new FilePermission(path.toAbsolutePath().toString(), "read")).forEach(result::add);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return result;
    }

    public static Collection<FilePermission> createTempDirPermission(String actions) {
        Object tempDir = System.getProperty("java.io.tmpdir");
        Assert.assertNotNull((String)"The java.io.tmpdir could not be resolved", (Object)tempDir);
        if (((String)tempDir).charAt(((String)tempDir).length() - 1) != File.separatorChar) {
            tempDir = (String)tempDir + File.separatorChar;
        }
        return List.of(new FilePermission((String)tempDir, "read"), new FilePermission((String)tempDir + "-", actions));
    }

    private static void addPermissionXml(Element permissionsElement, Iterable<? extends Permission> permissions) {
        for (Permission permission : permissions) {
            Element permissionElement = new Element("permission");
            Element classNameElement = new Element("class-name");
            Element nameElement = new Element("name");
            classNameElement.appendChild(permission.getClass().getName());
            nameElement.appendChild(permission.getName());
            permissionElement.appendChild((Node)classNameElement);
            permissionElement.appendChild((Node)nameElement);
            String actions = permission.getActions();
            if (actions != null && !actions.isEmpty()) {
                Element actionsElement = new Element("actions");
                actionsElement.appendChild(actions);
                permissionElement.appendChild((Node)actionsElement);
            }
            permissionsElement.appendChild((Node)permissionElement);
        }
    }

    static class NiceSerializer
    extends Serializer {
        NiceSerializer(OutputStream out) throws UnsupportedEncodingException {
            super(out, "UTF-8");
        }

        protected void writeXMLDeclaration() throws IOException {
            super.writeXMLDeclaration();
            super.breakLine();
        }
    }

    public static class Builder {
        private final Collection<Permission> permissions = new ArrayList<Permission>();

        public static Builder create() {
            return new Builder();
        }

        public Builder add(Permission permission) {
            this.permissions.add(permission);
            return this;
        }

        public Builder add(Permission ... permissions) {
            Collections.addAll(this.permissions, permissions);
            return this;
        }

        public Builder add(Collection<? extends Permission> permissions) {
            this.permissions.addAll(permissions);
            return this;
        }

        public Asset build() {
            return PermissionUtil.createPermissionsXmlAsset(this.permissions);
        }
    }
}

