/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.setup;

import java.util.Map;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public abstract class SystemPropertySetupTask
implements ServerSetupTask {
    private final Map<String, String> properties;

    protected SystemPropertySetupTask(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            ModelNode address = Operations.createAddress((String[])new String[]{"system-property", entry.getKey()});
            ModelNode op = Operations.createAddOperation((ModelNode)address);
            op.get("value").set(entry.getValue());
            builder.addStep(op);
        }
        ModelNode result = managementClient.getControllerClient().execute(builder.build());
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException(String.format("Failed to add system properties %s%n%s", this.properties, Operations.getFailureDescription((ModelNode)result).asString()));
        }
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            ModelNode address = Operations.createAddress((String[])new String[]{"system-property", entry.getKey()});
            builder.addStep(Operations.createRemoveOperation((ModelNode)address));
        }
        ModelNode result = managementClient.getControllerClient().execute(builder.build());
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException(String.format("Failed to remove system properties %s%n%s", this.properties, Operations.getFailureDescription((ModelNode)result).asString()));
        }
    }
}

