/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.setup;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.resteasy.setup.SnapshotServerSetupTask;

public class LoggingSetupTask
extends SnapshotServerSetupTask
implements ServerSetupTask {
    private static final Map<String, Set<String>> DEFAULT_LOG_LEVELS = Map.of("DEBUG", Collections.singleton("org.jboss.resteasy"));

    @Override
    protected void doSetup(ManagementClient client, String containerId) throws Exception {
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        String consoleHandlerName = this.getConsoleHandlerName();
        if (consoleHandlerName != null) {
            ModelNode address = Operations.createAddress((String[])new String[]{"subsystem", "logging", "console-handler", consoleHandlerName});
            builder.addStep(Operations.createWriteAttributeOperation((ModelNode)address, (String)"level", (String)"ALL"));
        }
        for (Map.Entry<String, Set<String>> entry : this.getLogLevels().entrySet()) {
            for (String logger : entry.getValue()) {
                ModelNode op;
                ModelNode address = logger.isBlank() ? Operations.createAddress((String[])new String[]{"subsystem", "logging", "root-logger", "ROOT"}) : Operations.createAddress((String[])new String[]{"subsystem", "logging", "logger", logger});
                if (this.loggerExists(client.getControllerClient(), address)) {
                    op = Operations.createWriteAttributeOperation((ModelNode)address, (String)"level", (String)entry.getKey());
                } else {
                    op = Operations.createAddOperation((ModelNode)address);
                    op.get("level").set(entry.getKey());
                }
                builder.addStep(op);
            }
        }
        this.executeOp(client.getControllerClient(), builder.build());
    }

    private boolean loggerExists(ModelControllerClient client, ModelNode address) throws IOException {
        ModelNode op = Operations.createReadResourceOperation((ModelNode)address);
        ModelNode result = client.execute(op);
        return Operations.isSuccessfulOutcome((ModelNode)result);
    }

    private void executeOp(ModelControllerClient client, Operation op) throws IOException {
        ModelNode result = client.execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException(Operations.getFailureDescription((ModelNode)result).asString());
        }
    }

    protected String getConsoleHandlerName() {
        return "CONSOLE";
    }

    protected Map<String, Set<String>> getLogLevels() {
        return DEFAULT_LOG_LEVELS;
    }
}

