/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.resteasy.utils.TestManagementClient;
import org.junit.Assert;

public class ServerReload {
    public static final int TIMEOUT = 100000;
    private static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();

    public static void executeReload(ModelControllerClient client) {
        ServerReload.executeReload(client, Operations.createOperation((String)"reload"));
    }

    public static void executeReload(ModelControllerClient client, ModelNode reloadOp) {
        block3: {
            try {
                ModelNode result = client.execute(reloadOp);
                if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                    Assert.fail((String)Operations.getFailureDescription((ModelNode)result).asString());
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ExecutionException || cause instanceof CancellationException) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client) {
        ServerReload.executeReloadAndWaitForCompletion(client, 100000);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, ModelNode reloadOp) {
        ServerReload.executeReloadAndWaitForCompletion(client, reloadOp, 100000);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, int timeout) {
        ServerReload.executeReload(client);
        ModelControllerClientConfiguration config = client instanceof TestManagementClient ? ((TestManagementClient)client).getConfiguration() : TestManagementClient.createDefaultConfig();
        ServerReload.waitForLiveServerToReload(timeout, config);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, ModelNode reloadOp, int timeout) {
        ServerReload.executeReload(client, reloadOp);
        ModelControllerClientConfiguration config = client instanceof TestManagementClient ? ((TestManagementClient)client).getConfiguration() : TestManagementClient.createDefaultConfig();
        ServerReload.waitForLiveServerToReload(timeout, config);
    }

    public static String getContainerRunningState(ModelControllerClient client) throws IOException {
        ModelNode rsp = client.execute(Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"server-state"));
        return Operations.isSuccessfulOutcome((ModelNode)rsp) ? Operations.readResult((ModelNode)rsp).asString() : "failed";
    }

    public static void reloadIfRequired(ModelControllerClient client) throws Exception {
        String runningState = ServerReload.getContainerRunningState(client);
        if ("reload-required".equalsIgnoreCase(runningState)) {
            ServerReload.executeReloadAndWaitForCompletion(client);
        } else {
            Assert.assertEquals((String)"Server state 'running' is expected", (Object)"running", (Object)runningState);
        }
    }

    /*
     * Loose catch block
     */
    private static void waitForLiveServerToReload(int timeout, ModelControllerClientConfiguration config) {
        long start = System.currentTimeMillis();
        ModelNode operation = Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"server-state");
        while (System.currentTimeMillis() - start < (long)timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                ModelControllerClient liveClient;
                block12: {
                    block13: {
                        liveClient = ModelControllerClient.Factory.create((ModelControllerClientConfiguration)config);
                        ModelNode result = liveClient.execute(operation);
                        if (!Operations.isSuccessfulOutcome((ModelNode)result) || !"running".equals(Operations.readResult((ModelNode)result).asString())) break block12;
                        if (liveClient == null) break block13;
                        liveClient.close();
                    }
                    return;
                }
                try {
                    continue;
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (liveClient == null) continue;
                    liveClient.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        Assert.fail((String)"Live Server did not reload in the imparted time.");
    }
}

