/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.setup;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.resteasy.utils.ServerReload;
import org.junit.Assert;

public class SnapshotServerSetupTask
implements ServerSetupTask {
    private final Map<String, AutoCloseable> snapshots = new HashMap<String, AutoCloseable>();

    public final void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.snapshots.put(containerId, SnapshotServerSetupTask.takeSnapshot(managementClient));
        this.doSetup(managementClient, containerId);
    }

    public final void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        AutoCloseable snapshot = this.snapshots.remove(containerId);
        if (snapshot != null) {
            snapshot.close();
        }
        this.nonManagementCleanUp();
    }

    protected void doSetup(ManagementClient client, String containerId) throws Exception {
    }

    protected void nonManagementCleanUp() throws Exception {
    }

    private static AutoCloseable takeSnapshot(ManagementClient client) {
        try {
            String snapshot;
            ModelNode op = Operations.createOperation((String)"take-snapshot");
            ModelNode result = client.getControllerClient().execute(op);
            if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                Assert.fail((String)("Reload operation didn't finish successfully: " + Operations.getFailureDescription((ModelNode)result).asString()));
            }
            String fileName = (snapshot = Operations.readResult((ModelNode)result).asString()).contains(File.separator) ? snapshot.substring(snapshot.lastIndexOf(File.separator) + 1) : snapshot;
            return () -> {
                SnapshotServerSetupTask.executeReloadAndWaitForCompletion(client.getControllerClient(), fileName);
                ModelNode result1 = client.getControllerClient().execute(Operations.createOperation((String)"write-config"));
                if (!Operations.isSuccessfulOutcome((ModelNode)result1)) {
                    Assert.fail((String)("Failed to write config after restoring from snapshot " + Operations.getFailureDescription((ModelNode)result1).asString()));
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to take snapshot", e);
        }
    }

    private static void executeReloadAndWaitForCompletion(ModelControllerClient client, String serverConfig) {
        ModelNode op = Operations.createOperation((String)"reload");
        if (serverConfig != null) {
            op.get("server-config").set(serverConfig);
        }
        ServerReload.executeReloadAndWaitForCompletion(client, op);
    }
}

