/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class PortProviderUtil {
    private static final int DEFAULT_PORT = 8080;
    private static final String PORT_ENV_VAR_NAME = "RESTEASY_PORT";
    private static final String PORT_PROPERTY_NAME = "org.jboss.resteasy.port";
    private static final String HOST_PROPERTY_NAME = "node";
    private static int port;
    private static String host;
    public static final String ASYNC_JOB_SERVICE_CONTEXT_KEY = "resteasy.async.job.service.enabled";
    private static boolean ipv6;
    private static final String QUARKUS_PROPERTY_FLAG = "quarkus.tester";
    private static boolean isQuarkus;

    public static <T> T createProxy(Class<T> clazz, String testName) {
        return PortProviderUtil.createProxy(clazz, "");
    }

    public static <T> T createProxy(Class<T> clazz, String path, String testName) {
        ResteasyWebTarget target = (ResteasyWebTarget)ResteasyClientBuilder.newClient().target(PortProviderUtil.generateURL(path, testName));
        return (T)target.proxy(clazz);
    }

    public static URI createURI(String path, String testName) {
        return URI.create(PortProviderUtil.generateURL(path, testName));
    }

    public static URL createURL(String path, String testName) throws MalformedURLException {
        return new URL(PortProviderUtil.generateURL(path, testName));
    }

    public static String generateBaseUrl(String testName) {
        return PortProviderUtil.generateURL("", testName);
    }

    public static String generateURL(String path, String testName) {
        return PortProviderUtil.generateURL(path, testName, PortProviderUtil.getHost(), PortProviderUtil.getPort());
    }

    public static String generateURL(String path, String testName, String hostName, int port) {
        String localTestName = isQuarkus ? "" : testName;
        String localPath = path;
        if (isQuarkus && path.startsWith("/")) {
            localPath = path.substring(1);
        }
        if (!ipv6) {
            return String.format("http://%s:%d/%s%s", hostName, port, localTestName, localPath);
        }
        return String.format("http://[%s]:%d/%s%s", hostName, port, localTestName, localPath);
    }

    public static int getPort() {
        return port;
    }

    public static String getHost() {
        return host;
    }

    public static boolean isIpv6() {
        return ipv6;
    }

    static {
        host = System.getProperty(HOST_PROPERTY_NAME, "localhost");
        ipv6 = Boolean.parseBoolean(System.getProperty("ipv6"));
        isQuarkus = false;
        boolean portSpecificInit = false;
        port = 8080;
        String property = System.getenv(PORT_ENV_VAR_NAME);
        if (property != null) {
            try {
                port = Integer.parseInt(property);
                portSpecificInit = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!portSpecificInit && (property = System.getProperty(PORT_PROPERTY_NAME)) != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        isQuarkus = Boolean.parseBoolean(System.getProperty(QUARKUS_PROPERTY_FLAG));
    }
}

