/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import java.io.File;
import java.util.ArrayList;
import org.jboss.resteasy.utils.maven.MavenUtil;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class TestUtilRxJava {
    private static String defaultRxJavaVersion = "1.3.2";
    private static String defaultRxJavaReactiveStreamsVersion = "1.2.1";
    private static String defaultSmallRyeContextPropagationVersion = "1.0.1";
    private static String defaultMicroProfileContextPropagationVersion = "1.0-RC1";

    private static String readSystemProperty(String name, String defaultValue) {
        String value = System.getProperty(name);
        return value == null ? defaultValue : value;
    }

    private static String getRxJavaVersion() {
        return TestUtilRxJava.readSystemProperty("version.rxjava", defaultRxJavaVersion);
    }

    private static String getRxJavaReactiveStreamsVersion() {
        return TestUtilRxJava.readSystemProperty("version.rxjava-reactive-streams", defaultRxJavaReactiveStreamsVersion);
    }

    private static String getSmallRyeContextPropagationVersion() {
        return TestUtilRxJava.readSystemProperty("version.smallrye-context-propagation", defaultSmallRyeContextPropagationVersion);
    }

    private static String getMicroProfileContextPropagationVersion() {
        return TestUtilRxJava.readSystemProperty("version.microprofile-context-propagation", defaultMicroProfileContextPropagationVersion);
    }

    private static File[] resolveRxJavaDependencies() {
        MavenUtil mavenUtil = MavenUtil.create(true);
        ArrayList<File> runtimeDependencies = new ArrayList<File>();
        try {
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.jboss.resteasy:resteasy-context-propagation:" + System.getProperty("version.resteasy.testsuite")));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.jboss.resteasy:resteasy-rxjava:" + System.getProperty("project.version")));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("org.eclipse.microprofile.context-propagation:microprofile-context-propagation-api:" + TestUtilRxJava.getMicroProfileContextPropagationVersion()));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("io.smallrye:smallrye-context-propagation:" + TestUtilRxJava.getSmallRyeContextPropagationVersion()));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("io.smallrye:smallrye-context-propagation-propagators-rxjava1:" + TestUtilRxJava.getSmallRyeContextPropagationVersion()));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("io.reactivex:rxjava:" + TestUtilRxJava.getRxJavaVersion()));
            runtimeDependencies.add(mavenUtil.createMavenGavFile("io.reactivex:rxjava-reactive-streams:" + TestUtilRxJava.getRxJavaReactiveStreamsVersion()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get artifacts from maven via Aether library", e);
        }
        File[] dependencies = runtimeDependencies.toArray(new File[0]);
        return dependencies;
    }

    public static void addRxJavaLibraries(WebArchive archive) {
        archive.addAsLibraries(TestUtilRxJava.resolveRxJavaDependencies());
    }

    public static void setManifestWithReactiveStreamsDependency(WebArchive archive) {
        archive.setManifest((Asset)new StringAsset("Manifest-Version: 1.0\nDependencies: org.reactivestreams"));
    }

    public static void setupRxJava(WebArchive archive) {
        TestUtilRxJava.addRxJavaLibraries(archive);
        TestUtilRxJava.setManifestWithReactiveStreamsDependency(archive);
    }
}

