/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.jboss.remoting3.MessageCancelledException;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.remote.IntIndexer;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.jboss.remoting3.remote.RemoteLogger;
import org.xnio.BrokenPipeException;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.streams.BufferPipeOutputStream;

final class OutboundMessage
extends MessageOutputStream {
    final short messageId;
    final RemoteConnectionChannel channel;
    final BufferPipeOutputStream pipeOutputStream;
    final int maximumWindow;
    int window;
    boolean closeCalled;
    boolean closeReceived;
    boolean cancelled;
    boolean cancelSent;
    boolean eofSent;
    boolean released;
    long remaining;
    final BufferPipeOutputStream.BufferWriter bufferWriter = new BufferPipeOutputStream.BufferWriter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Pooled<ByteBuffer> getBuffer(boolean firstBuffer) throws IOException {
            Pooled<ByteBuffer> pooled = OutboundMessage.this.allocate((byte)48);
            boolean ok = false;
            try {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                buffer.limit(buffer.limit() - 4);
                buffer.put(firstBuffer ? (byte)2 : 0);
                int windowPlusHeader = OutboundMessage.this.maximumWindow + 8;
                if (buffer.remaining() > windowPlusHeader) {
                    buffer.limit(windowPlusHeader);
                }
                ok = true;
                Pooled<ByteBuffer> pooled2 = pooled;
                return pooled2;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(Pooled<ByteBuffer> pooledBuffer, boolean eof) throws IOException {
            boolean ok = false;
            try {
                boolean intr;
                boolean sendCancel;
                ConnectedMessageChannel messageChannel;
                ByteBuffer buffer;
                block20: {
                    assert (Thread.holdsLock(OutboundMessage.this.pipeOutputStream));
                    if (OutboundMessage.this.closeCalled) {
                        throw new NotOpenException("Message was closed asynchronously by another thread");
                    }
                    if (OutboundMessage.this.cancelSent) {
                        throw new MessageCancelledException("Message was cancelled");
                    }
                    if (OutboundMessage.this.closeReceived) {
                        throw new BrokenPipeException("Remote side closed the message stream");
                    }
                    if (eof) {
                        OutboundMessage.this.closeCalled = true;
                        OutboundMessage.this.pipeOutputStream.notifyAll();
                    }
                    buffer = (ByteBuffer)pooledBuffer.getResource();
                    messageChannel = OutboundMessage.this.channel.getRemoteConnection().getChannel();
                    boolean badMsgSize = OutboundMessage.this.channel.getConnectionHandler().isFaultyMessageSize();
                    int msgSize = badMsgSize ? buffer.remaining() : buffer.remaining() - 8;
                    sendCancel = OutboundMessage.this.cancelled && !OutboundMessage.this.cancelSent;
                    intr = false;
                    if (msgSize > 0 && !sendCancel) {
                        do {
                            if (OutboundMessage.this.window >= msgSize) {
                                OutboundMessage.this.window -= msgSize;
                                RemoteLogger.log.trace("Message window is open, proceeding with send");
                                break block20;
                            }
                            try {
                                RemoteLogger.log.trace("Message window is closed, waiting");
                                OutboundMessage.this.pipeOutputStream.wait();
                            }
                            catch (InterruptedException e) {
                                OutboundMessage.this.cancelled = true;
                                intr = true;
                                break block20;
                            }
                            if (OutboundMessage.this.closeReceived) {
                                throw new BrokenPipeException("Remote side closed the message stream");
                            }
                            if (!OutboundMessage.this.closeCalled || eof) continue;
                            throw new NotOpenException("Message was closed asynchronously by another thread");
                        } while (!OutboundMessage.this.cancelSent);
                        throw new MessageCancelledException("Message was cancelled");
                    }
                }
                if (eof || sendCancel || intr) {
                    OutboundMessage.this.eofSent = true;
                    buffer.put(7, (byte)(buffer.get(7) | 1));
                    RemoteLogger.log.tracef("Sending message (with EOF) (%s) to %s", buffer, messageChannel);
                    if (!OutboundMessage.this.channel.getConnectionHandler().isMessageClose()) {
                        OutboundMessage.this.channel.free(OutboundMessage.this);
                    }
                    if (!OutboundMessage.this.released) {
                        OutboundMessage.this.released = true;
                        OutboundMessage.this.channel.closeOutboundMessage();
                    }
                }
                if (sendCancel || intr) {
                    OutboundMessage.this.cancelSent = true;
                    buffer.put(7, (byte)(buffer.get(7) | 4));
                    buffer.limit(8);
                    RemoteLogger.log.trace("Message includes cancel flag");
                }
                OutboundMessage.this.channel.getRemoteConnection().send(pooledBuffer);
                ok = true;
                if (intr) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted on write (message cancelled)");
                }
            }
            finally {
                if (!ok) {
                    pooledBuffer.free();
                }
            }
        }

        public void flush() throws IOException {
            RemoteLogger.log.trace("Flushing message channel");
        }
    };
    static final IntIndexer<OutboundMessage> INDEXER = new IntIndexer<OutboundMessage>(){

        @Override
        public int getKey(OutboundMessage argument) {
            return argument.messageId & 0xFFFF;
        }

        public boolean equals(OutboundMessage argument, int index) {
            return (argument.messageId & 0xFFFF) == index;
        }
    };

    OutboundMessage(short messageId, RemoteConnectionChannel channel, int window, long maxOutboundMessageSize) {
        this.messageId = messageId;
        this.channel = channel;
        this.window = this.maximumWindow = window;
        this.remaining = maxOutboundMessageSize;
        try {
            this.pipeOutputStream = new BufferPipeOutputStream(this.bufferWriter);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    Pooled<ByteBuffer> allocate(byte protoId) {
        Pooled<ByteBuffer> pooled = this.channel.allocate(protoId);
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        buffer.putShort(this.messageId);
        return pooled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int count) {
        BufferPipeOutputStream bufferPipeOutputStream = this.pipeOutputStream;
        synchronized (bufferPipeOutputStream) {
            if (RemoteLogger.log.isTraceEnabled()) {
                RemoteLogger.log.tracef("Acknowledged %d bytes on %s", count, this);
            }
            this.window += count;
            this.pipeOutputStream.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remoteClosed() {
        BufferPipeOutputStream bufferPipeOutputStream = this.pipeOutputStream;
        synchronized (bufferPipeOutputStream) {
            this.closeReceived = true;
            Pooled<ByteBuffer> pooled = this.pipeOutputStream.breakPipe();
            if (pooled != null) {
                pooled.free();
            }
            if (!this.eofSent && this.channel.getConnectionHandler().isMessageClose()) {
                this.eofSent = true;
                pooled = this.allocate((byte)48);
                boolean ok = false;
                try {
                    ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                    buffer.put((byte)1);
                    buffer.flip();
                    this.channel.getRemoteConnection().send(pooled);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        pooled.free();
                    }
                }
            }
            this.channel.free(this);
            if (!this.released) {
                this.released = true;
                this.channel.closeOutboundMessage();
            }
            this.pipeOutputStream.notifyAll();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remaining > 1L) {
            this.pipeOutputStream.write(b);
            --this.remaining;
        } else {
            throw this.overrun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOException overrun() {
        try {
            IOException iOException = new IOException("Maximum message size overrun");
            return iOException;
        }
        finally {
            this.cancel();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.remaining) {
            throw this.overrun();
        }
        this.pipeOutputStream.write(b, off, len);
        this.remaining -= (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.pipeOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this.pipeOutputStream;
        synchronized (bufferPipeOutputStream) {
            this.pipeOutputStream.notifyAll();
            this.pipeOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageOutputStream cancel() {
        BufferPipeOutputStream bufferPipeOutputStream = this.pipeOutputStream;
        synchronized (bufferPipeOutputStream) {
            this.cancelled = true;
            this.pipeOutputStream.notifyAll();
            IoUtils.safeClose((Closeable)this.pipeOutputStream);
            return this;
        }
    }

    public String toString() {
        return String.format("Outbound message ID %04x on %s", this.messageId, this.channel);
    }

    void dumpState(StringBuilder b) {
        b.append("            ").append(String.format("Outbound message ID %04x, window %d of %d\n", this.messageId & 0xFFFF, this.window, this.maximumWindow));
        b.append("            ").append("* flags: ");
        if (this.cancelled) {
            b.append("cancelled ");
        }
        if (this.cancelSent) {
            b.append("cancel-sent ");
        }
        if (this.closeReceived) {
            b.append("close-received ");
        }
        if (this.closeCalled) {
            b.append("closed-called ");
        }
        if (this.eofSent) {
            b.append("eof-sent ");
        }
        b.append('\n');
    }
}

