/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jboss.logging.Logger;
import org.xnio.BufferAllocator;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio._private.Messages;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SuspendableChannel;
import org.xnio.channels.TranslatingSuspendableChannel;

public class RemotingMessageChannel
extends TranslatingSuspendableChannel<ConnectedMessageChannel, ConnectedStreamChannel>
implements ConnectedMessageChannel {
    private static final Logger log = Logger.getLogger((String)"org.xnio.channels.framed");
    private Pooled<ByteBuffer> receiveBuffer;
    private ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    private Pooled<ByteBuffer> transmitBuffer;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private Integer messageLength;

    public RemotingMessageChannel(ConnectedStreamChannel channel, ByteBuffer receiveBuffer, ByteBuffer transmitBuffer) {
        super((SuspendableChannel)channel);
        this.receiveBuffer = Buffers.pooledWrapper((Buffer)receiveBuffer);
        this.transmitBuffer = Buffers.pooledWrapper((Buffer)transmitBuffer);
        log.tracef("Created new framed message channel around %s, receive buffer %s, transmit buffer %s", (Object)channel, (Object)receiveBuffer, (Object)transmitBuffer);
    }

    private boolean messageLengthPeeked() {
        return this.messageLength != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMessageLength() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.messageLengthPeeked()) {
                log.tracef("Already read a length", new Object[0]);
                return 0;
            }
            int res = ((ConnectedStreamChannel)this.channel).read(this.lengthBuffer);
            if (this.lengthBuffer.position() < 4) {
                if (res == -1) {
                    this.lengthBuffer.clear();
                }
                log.tracef("Did not read a length", new Object[0]);
                this.clearReadReady();
                return res;
            }
            this.lengthBuffer.flip();
            int length = this.lengthBuffer.getInt();
            if (length < 0) {
                throw new IOException("Unable to read message length. Invalid value of " + length);
            }
            this.messageLength = length;
            this.lengthBuffer.clear();
            return length;
        }
    }

    void adjustToMessageLength(int length) {
        if (length > 15000) {
            throw new IllegalArgumentException("Unable to adjust to message size. For security reason, the maximal buffer size is set to 15000");
        }
        if (length > ((ByteBuffer)this.receiveBuffer.getResource()).capacity()) {
            this.receiveBuffer = Buffers.pooledWrapper((Buffer)ByteBuffer.allocate(length + 4));
        }
        if (length > ((ByteBuffer)this.transmitBuffer.getResource()).capacity()) {
            this.transmitBuffer = Buffers.pooledWrapper((Buffer)ByteBuffer.allocate(length + 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int receive(AdjustedBuffer buffer) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.isReadShutDown()) {
                return -1;
            }
            int messageLength = this.readMessageLength();
            if (messageLength <= 0) {
                return messageLength;
            }
            if (messageLength > ((ByteBuffer)buffer.original.getResource()).capacity() && messageLength < 15000) {
                buffer.adjusted = Buffers.allocatedBufferPool((BufferAllocator)BufferAllocator.BYTE_BUFFER_ALLOCATOR, (int)messageLength).allocate();
                this.adjustToMessageLength(messageLength);
            }
            ByteBuffer receiveBuffer = (ByteBuffer)buffer.getAdjustedBuffer().getResource();
            return this.receive(receiveBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int receive(ByteBuffer buffer) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.isReadShutDown()) {
                return -1;
            }
            ByteBuffer receiveBuffer = (ByteBuffer)this.receiveBuffer.getResource();
            int res = 0;
            ConnectedStreamChannel channel = (ConnectedStreamChannel)this.channel;
            while ((res = channel.read(receiveBuffer)) > 0) {
            }
            if (!this.messageLengthPeeked() && receiveBuffer.position() < 4) {
                if (res == -1) {
                    receiveBuffer.clear();
                }
                log.tracef("Did not read a length", new Object[0]);
                this.clearReadReady();
                return res;
            }
            receiveBuffer.flip();
            try {
                int length;
                if (this.messageLengthPeeked()) {
                    length = this.messageLength;
                } else {
                    length = receiveBuffer.getInt();
                    if (length < 0 || length > receiveBuffer.capacity() - 4) {
                        Buffers.unget((Buffer)receiveBuffer, (int)4);
                        throw new IOException("Received an invalid message length of " + length);
                    }
                }
                if (receiveBuffer.remaining() < length) {
                    if (res == -1) {
                        receiveBuffer.clear();
                    } else {
                        Buffers.unget((Buffer)receiveBuffer, (int)4);
                        receiveBuffer.compact();
                    }
                    log.tracef("Did not read enough bytes for a full message", new Object[0]);
                    this.clearReadReady();
                    int n = res;
                    return n;
                }
                if (buffer.hasRemaining()) {
                    log.tracef("Copying message from %s into %s", (Object)receiveBuffer, (Object)buffer);
                    Buffers.copy((ByteBuffer)buffer, (ByteBuffer)Buffers.slice((ByteBuffer)receiveBuffer, (int)length));
                } else {
                    log.tracef("Not copying message from %s into full buffer %s", (Object)receiveBuffer, (Object)buffer);
                    Buffers.skip((Buffer)receiveBuffer, (int)length);
                }
                receiveBuffer.compact();
                int n = length;
                return n;
            }
            finally {
                this.messageLength = null;
                if (res != -1 && receiveBuffer.position() >= 4 && receiveBuffer.position() >= 4 + receiveBuffer.getInt(0)) {
                    this.setReadReady();
                }
            }
        }
    }

    public long receive(ByteBuffer[] buffers) throws IOException {
        return this.receive(buffers, 0, buffers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long receive(ByteBuffer[] buffers, int offs, int len) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.isReadShutDown()) {
                return -1L;
            }
            ByteBuffer receiveBuffer = (ByteBuffer)this.receiveBuffer.getResource();
            int res = 0;
            ConnectedStreamChannel channel = (ConnectedStreamChannel)this.channel;
            while ((res = channel.read(receiveBuffer)) > 0) {
            }
            if (receiveBuffer.position() < 4) {
                if (res == -1) {
                    receiveBuffer.clear();
                }
                log.tracef("Did not read a length", new Object[0]);
                this.clearReadReady();
                return res;
            }
            receiveBuffer.flip();
            try {
                int length = receiveBuffer.getInt();
                if (length < 0 || length > receiveBuffer.capacity() - 4) {
                    Buffers.unget((Buffer)receiveBuffer, (int)4);
                    throw Messages.msg.recvInvalidMsgLength(length);
                }
                if (receiveBuffer.remaining() < length) {
                    if (res == -1) {
                        receiveBuffer.clear();
                    } else {
                        Buffers.unget((Buffer)receiveBuffer, (int)4);
                        receiveBuffer.compact();
                    }
                    log.tracef("Did not read enough bytes for a full message", new Object[0]);
                    this.clearReadReady();
                    long l = res;
                    return l;
                }
                if (Buffers.hasRemaining((Buffer[])buffers)) {
                    log.tracef("Copying message from %s into multiple buffers", (Object)receiveBuffer);
                    Buffers.copy((ByteBuffer[])buffers, (int)offs, (int)len, (ByteBuffer)Buffers.slice((ByteBuffer)receiveBuffer, (int)length));
                } else {
                    log.tracef("Not copying message from %s into multiple full buffers", (Object)receiveBuffer);
                    Buffers.skip((Buffer)receiveBuffer, (int)length);
                }
                receiveBuffer.compact();
                long l = length;
                return l;
            }
            finally {
                if (res != -1 && receiveBuffer.position() >= 4 && receiveBuffer.position() >= 4 + receiveBuffer.getInt(0)) {
                    this.setReadReady();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownReadsAction(boolean writeComplete) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            log.tracef("Shutting down reads on %s", (Object)this);
            try {
                ((ByteBuffer)this.receiveBuffer.getResource()).clear();
                this.lengthBuffer.clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.receiveBuffer.free();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ((ConnectedStreamChannel)this.channel).shutdownReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(ByteBuffer buffer) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.isWriteShutDown()) {
                throw new EOFException("Writes have been shut down");
            }
            if (!buffer.hasRemaining()) {
                return true;
            }
            ByteBuffer transmitBuffer = (ByteBuffer)this.transmitBuffer.getResource();
            int remaining = buffer.remaining();
            if (remaining > transmitBuffer.capacity() - 4) {
                throw Messages.msg.txMsgTooLarge();
            }
            log.tracef("Accepting %s into %s", (Object)buffer, (Object)transmitBuffer);
            if (transmitBuffer.remaining() < 4 + remaining && !this.doFlushBuffer()) {
                log.tracef("Insufficient room to accept %s into %s", (Object)buffer, (Object)transmitBuffer);
                return false;
            }
            transmitBuffer.putInt(remaining);
            transmitBuffer.put(buffer);
            log.tracef("Accepted a message into %s", (Object)transmitBuffer);
            this.doFlush();
            return true;
        }
    }

    public boolean send(ByteBuffer[] buffers) throws IOException {
        return this.send(buffers, 0, buffers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(ByteBuffer[] buffers, int offs, int len) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.isWriteShutDown()) {
                throw Messages.msg.writeShutDown();
            }
            if (!Buffers.hasRemaining((Buffer[])buffers, (int)offs, (int)len)) {
                return true;
            }
            ByteBuffer transmitBuffer = (ByteBuffer)this.transmitBuffer.getResource();
            long remaining = Buffers.remaining((Buffer[])buffers, (int)offs, (int)len);
            if (remaining > (long)transmitBuffer.capacity() - 4L) {
                throw new IOException("Transmitted message is too large");
            }
            log.tracef("Accepting multiple buffers into %s", (Object)transmitBuffer);
            if ((long)transmitBuffer.remaining() < 4L + remaining && !this.doFlushBuffer()) {
                log.tracef("Insufficient room to accept multiple buffers into %s", (Object)transmitBuffer);
                return false;
            }
            transmitBuffer.putInt((int)remaining);
            Buffers.copy((ByteBuffer)transmitBuffer, (ByteBuffer[])buffers, (int)offs, (int)len);
            log.tracef("Accepted a message into %s", (Object)transmitBuffer);
            this.doFlush();
            return true;
        }
    }

    public boolean sendFinal(ByteBuffer buffer) throws IOException {
        if (this.send(buffer)) {
            this.shutdownWrites();
            return true;
        }
        return false;
    }

    public boolean sendFinal(ByteBuffer[] buffers) throws IOException {
        if (this.send(buffers)) {
            this.shutdownWrites();
            return true;
        }
        return false;
    }

    public boolean sendFinal(ByteBuffer[] buffers, int offs, int len) throws IOException {
        if (this.send(buffers, offs, len)) {
            this.shutdownWrites();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushAction(boolean shutDown) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            return this.doFlushBuffer() && ((ConnectedStreamChannel)this.channel).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownWritesComplete(boolean readShutDown) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            log.tracef("Finished shutting down writes on %s", (Object)this);
            try {
                this.transmitBuffer.free();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ((ConnectedStreamChannel)this.channel).shutdownWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlushBuffer() throws IOException {
        assert (Thread.holdsLock(this.writeLock));
        ByteBuffer buffer = (ByteBuffer)this.transmitBuffer.getResource();
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                int res = ((ConnectedStreamChannel)this.channel).write(buffer);
                if (res != 0) continue;
                log.tracef("Did not fully flush %s", (Object)this);
                boolean bl = false;
                return bl;
            }
            log.tracef("Fully flushed %s", (Object)this);
            boolean bl = true;
            return bl;
        }
        finally {
            buffer.compact();
        }
    }

    private boolean doFlush() throws IOException {
        return this.doFlushBuffer() && ((ConnectedStreamChannel)this.channel).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAction(boolean readShutDown, boolean writeShutDown) throws IOException {
        Object object;
        boolean error = false;
        if (!writeShutDown) {
            object = this.writeLock;
            synchronized (object) {
                try {
                    if (!this.doFlush()) {
                        error = true;
                    }
                }
                catch (Throwable t) {
                    error = true;
                }
                try {
                    this.transmitBuffer.free();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (!readShutDown) {
            object = this.readLock;
            synchronized (object) {
                try {
                    this.receiveBuffer.free();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        try {
            if (error) {
                throw Messages.msg.unflushedData();
            }
            ((ConnectedStreamChannel)this.channel).close();
        }
        finally {
            IoUtils.safeClose((Closeable)this.channel);
        }
    }

    public SocketAddress getPeerAddress() {
        return ((ConnectedStreamChannel)this.channel).getPeerAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)((ConnectedStreamChannel)this.channel).getPeerAddress(type);
    }

    public SocketAddress getLocalAddress() {
        return ((ConnectedStreamChannel)this.channel).getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)((ConnectedStreamChannel)this.channel).getLocalAddress(type);
    }

    public ConnectedStreamChannel getChannel() {
        return (ConnectedStreamChannel)this.channel;
    }

    static class AdjustedBuffer {
        private final Pooled<ByteBuffer> original;
        private Pooled<ByteBuffer> adjusted;

        AdjustedBuffer(Pooled<ByteBuffer> original) {
            this.original = original;
        }

        Pooled<ByteBuffer> getAdjustedBuffer() {
            return this.adjusted == null ? this.original : this.adjusted;
        }
    }
}

