/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.jboss.remoting3.remote.RemoteProtocol;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.RemotingServiceDescriptor;
import org.jboss.xnio.Connector;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.Xnio;
import org.jboss.xnio.channels.ConnectedStreamChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteProtocolDescriptor
implements RemotingServiceDescriptor<ConnectionProviderFactory> {
    @Override
    public Class<ConnectionProviderFactory> getType() {
        return ConnectionProviderFactory.class;
    }

    @Override
    public String getName() {
        return "remote";
    }

    @Override
    public ConnectionProviderFactory getService(Properties properties) throws IOException {
        TcpConnector connector;
        String providerName = properties.getProperty("remote.xnio.provider", "default");
        boolean useSsl = Boolean.parseBoolean(properties.getProperty("remote.ssl.enable", "true"));
        Xnio xnio = Xnio.getInstance((String)providerName);
        OptionMap connectorOptions = OptionMap.builder().parseAll(properties, "remote.connector.option").getMap();
        if (useSsl) {
            try {
                connector = xnio.createSslTcpConnector(null, connectorOptions);
            }
            catch (Exception e) {
                IOException ioe = new IOException("Failed to create connector");
                ioe.initCause(e);
                throw ioe;
            }
        } else {
            connector = xnio.createTcpConnector(connectorOptions);
        }
        return new ConnectionProviderFactory((Connector)connector){
            final /* synthetic */ Connector val$connector;
            {
                this.val$connector = connector;
            }

            public ConnectionProvider createInstance(ConnectionProviderContext context) {
                return RemoteProtocol.getRemoteConnectionProvider(context, (Connector<InetSocketAddress, ? extends ConnectedStreamChannel<InetSocketAddress>>)this.val$connector);
            }
        };
    }
}

