/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.StreamCorruptedException;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.remote.PrimaryExternalizerFactory;

final class PrimaryObjectTable
implements ObjectTable {
    private final Endpoint endpoint;
    private static final ObjectTable.Writer ZERO_WRITER = new ByteWriter(0);
    private static final ObjectTable.Writer ONE_WRITER = new ByteWriter(1);

    PrimaryObjectTable(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
        if (object == this.endpoint) {
            return ZERO_WRITER;
        }
        if (object == PrimaryExternalizerFactory.RequestHandlerConnectorExternalizer.INSTANCE) {
            return ONE_WRITER;
        }
        return null;
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int id = unmarshaller.readUnsignedByte();
        switch (id) {
            case 0: {
                return this.endpoint;
            }
            case 1: {
                return PrimaryExternalizerFactory.RequestHandlerConnectorExternalizer.INSTANCE;
            }
        }
        throw new StreamCorruptedException("Unknown object table ID byte " + id);
    }

    private static final class ByteWriter
    implements ObjectTable.Writer {
        private final byte b;

        private ByteWriter(int b) {
            this.b = (byte)b;
        }

        public void writeObject(Marshaller marshaller, Object object) throws IOException {
            marshaller.writeByte((int)this.b);
        }
    }
}

