/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.util.IntKeyMap;
import org.jboss.remoting3.RemoteRequestException;
import org.jboss.remoting3.remote.InboundClient;
import org.jboss.remoting3.remote.InboundRequest;
import org.jboss.remoting3.remote.OutboundReplyHandler;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.IoUtils;

final class InboundRequestTask
implements Runnable {
    private final InboundRequest inboundRequest;
    private final int rid;
    private final int cid;
    private RemoteConnectionHandler remoteConnectionHandler;

    InboundRequestTask(RemoteConnectionHandler remoteConnectionHandler, InboundRequest inboundRequest, int rid, int cid) {
        this.remoteConnectionHandler = remoteConnectionHandler;
        this.inboundRequest = inboundRequest;
        this.rid = rid;
        this.cid = cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InboundClient inboundClient;
        IntKeyMap<InboundClient> inboundClients;
        Object request;
        OutboundReplyHandler replyHandler;
        InboundRequest inboundRequest;
        InboundRequest inboundRequest2 = inboundRequest = this.inboundRequest;
        synchronized (inboundRequest2) {
            replyHandler = new OutboundReplyHandler(inboundRequest, this.rid);
            inboundRequest.setReplyHandler(replyHandler);
        }
        try {
            Unmarshaller unmarshaller = this.remoteConnectionHandler.getMarshallerFactory().createUnmarshaller(this.remoteConnectionHandler.getMarshallingConfiguration());
            try {
                RemoteConnectionHandler.log.trace("Unmarshalling inbound request");
                unmarshaller.start((ByteInput)inboundRequest.getByteInput());
                RemoteConnectionHandler old = RemoteConnectionHandler.setCurrent(this.remoteConnectionHandler);
                try {
                    request = unmarshaller.readObject();
                    unmarshaller.close();
                }
                finally {
                    RemoteConnectionHandler.setCurrent(old);
                }
                RemoteConnectionHandler.log.trace("Unmarshalled inbound request %s", request);
            }
            finally {
                IoUtils.safeClose((Closeable)unmarshaller);
            }
        }
        catch (IOException e) {
            RemoteConnectionHandler.log.trace((Throwable)e, "Unmarshalling inbound request failed", new Object[0]);
            SpiUtils.safeHandleException(replyHandler, e);
            return;
        }
        catch (Exception e) {
            RemoteConnectionHandler.log.trace((Throwable)e, "Unmarshalling inbound request failed", new Object[0]);
            SpiUtils.safeHandleException(replyHandler, new RemoteRequestException(e));
            return;
        }
        catch (Error e) {
            RemoteConnectionHandler.log.trace((Throwable)e, "Unmarshalling inbound request failed", new Object[0]);
            SpiUtils.safeHandleException(replyHandler, new RemoteRequestException(e));
            throw e;
        }
        Object object = inboundClients = this.remoteConnectionHandler.getInboundClients();
        synchronized (object) {
            inboundClient = (InboundClient)inboundClients.get(this.cid);
        }
        object = inboundRequest;
        synchronized (object) {
            inboundRequest.setCancellable(inboundClient.getHandler().receiveRequest(request, replyHandler));
        }
    }
}

