/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.ProviderDescriptor;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.RequestListener;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.ProtocolServiceType;
import org.jboss.remoting3.spi.RemotingServiceDescriptor;
import org.jboss.remoting3.spi.RequestHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Remoting {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting");
    private static Endpoint configuredEndpoint;
    private static final Object lock;
    private static final RemotingPermission CREATE_ENDPOINT_PERM;
    private static final RemotingPermission GET_CONFIGURED_ENDPOINT_PERM;
    private static final String PROPERTIES = "remoting.properties";
    private static final String PROPERTY_FILE_PROPNAME = "remoting.property.file";
    static final Option<Boolean> UNCLOSEABLE;
    private static final ThreadFactory OUR_THREAD_FACTORY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Endpoint getConfiguredEndpoint() throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIGURED_ENDPOINT_PERM);
        }
        Object object = lock;
        synchronized (object) {
            Endpoint endpoint = configuredEndpoint;
            if (endpoint != null) {
                return endpoint;
            }
            configuredEndpoint = Remoting.createConfigured();
            return configuredEndpoint;
        }
    }

    private static Endpoint createConfigured() throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Endpoint>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Endpoint run() {
                    Properties props;
                    boolean ok;
                    block37: {
                        ok = false;
                        String fileName = System.getProperty(Remoting.PROPERTY_FILE_PROPNAME, Remoting.PROPERTIES);
                        log.trace("Searching for properties file named '%s'", (Object)fileName);
                        props = new Properties();
                        try {
                            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fileName);
                            if (stream != null) {
                                try {
                                    InputStreamReader reader = new InputStreamReader(stream, "utf-8");
                                    try {
                                        props.load(reader);
                                        reader.close();
                                        log.trace("Loaded properties");
                                        break block37;
                                    }
                                    finally {
                                        IoUtils.safeClose((Closeable)reader);
                                    }
                                }
                                finally {
                                    IoUtils.safeClose((Closeable)stream);
                                }
                            }
                            log.trace("No properties file found in classpath");
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    final ThreadPoolExecutor executor = new ThreadPoolExecutor(Integer.parseInt(props.getProperty("endpoint.threadpool.coresize", "8")), Integer.parseInt(props.getProperty("endpoint.threadpool.maxsize", "64")), Long.parseLong(props.getProperty("endpoint.threadpool.keepaliveseconds", "30")), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(Integer.parseInt(props.getProperty("endpoint.threadpool.queuelength", "64"))), OUR_THREAD_FACTORY, new ThreadPoolExecutor.CallerRunsPolicy());
                    try {
                        Endpoint endpoint;
                        block38: {
                            Endpoint endpoint2;
                            try {
                                endpoint2 = Remoting.createEndpoint(props.getProperty("endpoint.name", "endpoint"), executor, OptionMap.builder().parseAll(props, "endpoint.option.").set(UNCLOSEABLE, true).getMap());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            log.trace("Created %s from configuration", (Object)endpoint2);
                            try {
                                endpoint2.addCloseHandler(new CloseHandler<Endpoint>(){

                                    @Override
                                    public void handleClose(Endpoint closed) {
                                        executor.shutdown();
                                    }
                                });
                                Remoting.addServices(endpoint2, ProtocolServiceType.CLASS_TABLE, props);
                                Remoting.addServices(endpoint2, ProtocolServiceType.OBJECT_TABLE, props);
                                Remoting.addServices(endpoint2, ProtocolServiceType.CLASS_RESOLVER, props);
                                Remoting.addServices(endpoint2, ProtocolServiceType.OBJECT_RESOLVER, props);
                                Remoting.addServices(endpoint2, ProtocolServiceType.CLASS_EXTERNALIZER_FACTORY, props);
                                for (RemotingServiceDescriptor descriptor : ServiceLoader.load(RemotingServiceDescriptor.class)) {
                                    Object service;
                                    String name = descriptor.getName();
                                    Class serviceType = descriptor.getType();
                                    try {
                                        service = descriptor.getService(props);
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    try {
                                        if (serviceType == ConnectionProviderFactory.class) {
                                            endpoint2.addConnectionProvider(name, (ConnectionProviderFactory)service);
                                            continue;
                                        }
                                        if (serviceType == ClassTable.class) {
                                            endpoint2.addProtocolService(ProtocolServiceType.CLASS_TABLE, name, (ClassTable)service);
                                            continue;
                                        }
                                        if (serviceType == ObjectTable.class) {
                                            endpoint2.addProtocolService(ProtocolServiceType.OBJECT_TABLE, name, (ObjectTable)service);
                                            continue;
                                        }
                                        if (serviceType == ClassResolver.class) {
                                            endpoint2.addProtocolService(ProtocolServiceType.CLASS_RESOLVER, name, (ClassResolver)service);
                                            continue;
                                        }
                                        if (serviceType == ObjectResolver.class) {
                                            endpoint2.addProtocolService(ProtocolServiceType.OBJECT_RESOLVER, name, (ObjectResolver)service);
                                            continue;
                                        }
                                        if (serviceType != ClassExternalizerFactory.class) continue;
                                        endpoint2.addProtocolService(ProtocolServiceType.CLASS_EXTERNALIZER_FACTORY, name, (ClassExternalizerFactory)service);
                                    }
                                    catch (DuplicateRegistrationException e) {
                                        log.warn("Duplicate registration for '" + name + "' of " + serviceType);
                                    }
                                }
                                HashMap<String, ProviderDescriptor> found = new HashMap<String, ProviderDescriptor>();
                                for (ProviderDescriptor descriptor : ServiceLoader.load(ProviderDescriptor.class)) {
                                    String name = descriptor.getName();
                                    if (found.containsKey(name) && ((ProviderDescriptor)found.get(name)).getSupportedVersions()[0] >= descriptor.getSupportedVersions()[0]) continue;
                                    found.put(name, descriptor);
                                }
                                for (String name : found.keySet()) {
                                    try {
                                        endpoint2.addProtocolService(ProtocolServiceType.MARSHALLER_PROVIDER_DESCRIPTOR, name, found.get(name));
                                    }
                                    catch (DuplicateRegistrationException e) {
                                        log.warn("Duplicate registration for '" + name + "' of " + MarshallerFactory.class);
                                    }
                                }
                                ok = true;
                                endpoint = endpoint2;
                                if (ok) break block38;
                            }
                            catch (Throwable throwable) {
                                if (!ok) {
                                    IoUtils.safeClose((Closeable)endpoint2);
                                }
                                throw throwable;
                            }
                            IoUtils.safeClose((Closeable)endpoint2);
                        }
                        return endpoint;
                    }
                    finally {
                        if (!ok) {
                            executor.shutdown();
                            try {
                                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            Throwable c = e.getCause();
            if (c instanceof IOException) {
                throw (IOException)c;
            }
            throw e;
        }
    }

    private static <T> void addServices(Endpoint endpoint, ProtocolServiceType<T> serviceType, Properties props) {
        String basePropName = serviceType.getName().toLowerCase();
        String instances = props.getProperty(endpoint.getName() + "." + basePropName + "_list");
        Class<T> valueClass = serviceType.getValueClass();
        if (instances != null) {
            for (String name : instances.split(",")) {
                String trimmed = name.trim();
                String className = props.getProperty(name + "." + basePropName + "." + trimmed + ".class");
                if (className == null) continue;
                try {
                    Class<T> instanceType = Class.forName(className).asSubclass(valueClass);
                    T instance = instanceType.getConstructor(new Class[0]).newInstance(new Object[0]);
                    log.trace("Adding protocol service '%s' of type '%s'", (Object)name, serviceType);
                    endpoint.addProtocolService(serviceType, name, instance);
                }
                catch (InvocationTargetException e) {
                    log.warn(e.getCause(), "Unable to create %s instance '%s'", serviceType, (Object)name);
                }
                catch (Exception e) {
                    log.warn("Unable to register %s '%s': %s", serviceType, (Object)name, (Object)e);
                }
            }
        }
    }

    public static Endpoint createEndpoint(String endpointName, Executor executor, OptionMap optionMap) throws IOException {
        if (endpointName == null) {
            throw new NullPointerException("endpointName is null");
        }
        if (optionMap == null) {
            throw new NullPointerException("optionMap is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_ENDPOINT_PERM);
        }
        EndpointImpl endpoint = new EndpointImpl(executor, endpointName, optionMap);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, O> Client<I, O> createLocalClient(Endpoint endpoint, RequestListener<I, O> requestListener, Class<I> requestClass, Class<O> replyClass) throws IOException {
        boolean ok = false;
        RequestHandler requestHandler = endpoint.createLocalRequestHandler(requestListener, requestClass, replyClass);
        try {
            Client<I, O> client = endpoint.createClient(requestHandler, requestClass, replyClass);
            ok = true;
            Client<I, O> client2 = client;
            return client2;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)requestHandler);
            }
        }
    }

    private Remoting() {
    }

    static {
        lock = new Object();
        CREATE_ENDPOINT_PERM = new RemotingPermission("createEndpoint");
        GET_CONFIGURED_ENDPOINT_PERM = new RemotingPermission("getConfiguredEndpoint");
        UNCLOSEABLE = Option.simple(Remoting.class, (String)"UNCLOSEABLE", Boolean.class);
        OUR_THREAD_FACTORY = new ThreadFactory(){
            private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

            public Thread newThread(Runnable r) {
                Thread thread = this.defaultThreadFactory.newThread(r);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread t, Throwable e) {
                        log.error(e, "Uncaught exception in thread %s", (Object)t);
                    }
                });
                return thread;
            }
        };
    }
}

