/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.io.Serializable;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.ClientConnector;
import org.jboss.remoting3.ClientContext;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.spi.RequestHandler;
import org.jboss.remoting3.spi.RequestHandlerConnector;
import org.jboss.xnio.FutureResult;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.Result;
import org.jboss.xnio.TranslatingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientConnectorImpl<I, O>
implements ClientConnector<I, O>,
Serializable {
    private static final long serialVersionUID = -263585821458635701L;
    private final transient ClientContext clientContext;
    private final RequestHandlerConnector requestHandlerConnector;
    private final Endpoint endpoint;
    private final Class<I> requestClass;
    private final Class<O> replyClass;

    ClientConnectorImpl(RequestHandlerConnector requestHandlerConnector, Endpoint endpoint, Class<I> requestClass, Class<O> replyClass, ClientContext clientContext) {
        this.requestHandlerConnector = requestHandlerConnector;
        this.endpoint = endpoint;
        this.requestClass = requestClass;
        this.replyClass = replyClass;
        this.clientContext = clientContext;
    }

    @Override
    public IoFuture<? extends Client<I, O>> getFutureClient() throws SecurityException {
        FutureResult futureResult = new FutureResult();
        this.requestHandlerConnector.createRequestHandler((Result<RequestHandler>)new TranslatingResult<RequestHandler, Client<I, O>>((Result)futureResult){

            protected Client<I, O> translate(RequestHandler input) throws IOException {
                return ClientConnectorImpl.this.endpoint.createClient(input, ClientConnectorImpl.this.requestClass, ClientConnectorImpl.this.replyClass);
            }
        });
        return futureResult.getIoFuture();
    }

    @Override
    public ClientContext getClientContext() {
        if (this.clientContext == null) {
            throw new SecurityException("Connector has already been sent");
        }
        return this.clientContext;
    }
}

