/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.serialization;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.samples.serialization.NonSerializablePayload;

public class SerializationClient {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;

    public void makeInvocation(String locatorURI) throws Throwable {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Calling remoting server with locator uri of: " + locatorURI);
        Client remotingClient = new Client(locator);
        remotingClient.connect();
        NonSerializablePayload payload = new NonSerializablePayload("foo", 1);
        System.out.println("Invoking server with request of '" + payload + "'");
        Object response = remotingClient.invoke(payload);
        System.out.println("Invocation response: " + response);
    }

    public static void main(String[] args) {
        if (args != null && args.length == 3) {
            transport = args[0];
            host = args[1];
            port = Integer.parseInt(args[2]);
        }
        String locatorURI = transport + "://" + host + ":" + port + "/?serializationtype=jboss";
        SerializationClient client = new SerializationClient();
        try {
            client.makeInvocation(locatorURI);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

