/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.Version;
import org.jboss.remoting.util.SecurityUtility;

public class RemotingRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    static final long serialVersionUID;
    protected static Logger log;
    protected static Map configMaps;
    protected static Map socketFactories;
    protected Map configuration;
    protected InvokerLocator invokerLocator;
    protected transient SocketFactory socketFactory;
    private int timeout = 60000;
    protected String hostName;

    public static void addLocalConfiguration(InvokerLocator invokerLocator, Map localConfig) {
        log.debug((Object)("adding local configuration for: " + invokerLocator));
        configMaps.put(new ComparableHolder(invokerLocator), localConfig);
    }

    public static void removeLocalConfiguration(InvokerLocator invokerLocator) {
        log.debug((Object)("removing local configuration for: " + invokerLocator));
        Object o = configMaps.remove(new ComparableHolder(invokerLocator));
        if (o == null) {
            log.warn((Object)("trying to delete unknown key: " + invokerLocator));
        }
        ComparableHolder holder = new ComparableHolder(invokerLocator);
        socketFactories.remove(holder);
    }

    public RemotingRMIClientSocketFactory(InvokerLocator locator, String hostName, int timeout, Map config) {
        this.invokerLocator = locator;
        this.hostName = hostName;
        this.timeout = timeout;
        this.configuration = new HashMap(config);
    }

    public Socket createSocket(String host, int port) throws IOException {
        String effectiveHost;
        String string = effectiveHost = this.hostName != null ? this.hostName : host;
        if (log.isTraceEnabled()) {
            log.trace((Object)("host: " + host + ", effective host: " + effectiveHost + ", port: " + port));
        }
        if (this.invokerLocator != null) {
            ComparableHolder holder = new ComparableHolder(this.invokerLocator);
            if (!configMaps.containsKey(holder)) {
                if (Thread.currentThread().getName().indexOf("RMI") >= 0) {
                    log.debug((Object)("unrecognized invoker locator: " + this.invokerLocator));
                    log.debug((Object)"unable to retrieve socket factory: returning plain socket");
                } else {
                    log.warn((Object)(Thread.currentThread().getName() + " unrecognized invoker locator: " + this.invokerLocator));
                    log.warn((Object)"unable to retrieve socket factory: returning plain socket");
                }
                return SecurityUtility.createSocket(effectiveHost, port);
            }
            this.socketFactory = this.retrieveSocketFactory(holder);
        }
        Socket socket = null;
        socket = this.socketFactory != null ? SecurityUtility.createSocket(this.socketFactory, effectiveHost, port) : SecurityUtility.createSocket(effectiveHost, port);
        socket.setSoTimeout(this.timeout);
        this.socketFactory = null;
        return socket;
    }

    public SocketFactory retrieveSocketFactory(ComparableHolder holder) throws IOException {
        SocketFactory sf = (SocketFactory)socketFactories.get(holder);
        if (sf == null) {
            HashMap tempConfig = new HashMap(this.configuration);
            Map localConfig = (Map)configMaps.get(holder);
            if (localConfig != null) {
                tempConfig.putAll(localConfig);
            }
            if (tempConfig.containsKey("customSocketFactory")) {
                sf = (SocketFactory)tempConfig.get("customSocketFactory");
            }
            if (sf == null) {
                sf = SocketFactory.getDefault();
                sf = AbstractInvoker.wrapSocketFactory(sf, tempConfig);
            }
            socketFactories.put(holder, sf);
        }
        return sf;
    }

    public void clear() {
        this.configuration = null;
        this.invokerLocator = null;
        this.socketFactory = null;
    }

    static {
        log = Logger.getLogger((Class)RemotingRMIClientSocketFactory.class);
        configMaps = Collections.synchronizedMap(new HashMap());
        socketFactories = Collections.synchronizedMap(new HashMap());
        serialVersionUID = Version.getDefaultVersion() == 1 ? -7491556589517716155L : -3039839695840773968L;
    }

    protected static class ComparableHolder {
        private String protocol;
        private InetAddress host;
        private int port;
        private int hashCode;

        public ComparableHolder(InvokerLocator invokerLocator) {
            this.protocol = invokerLocator.getProtocol().toLowerCase();
            try {
                this.host = SecurityUtility.getAddressByName(invokerLocator.getHost());
            }
            catch (UnknownHostException e) {
                log.error((Object)("unable to resolve host: " + invokerLocator.getHost()), (Throwable)e);
            }
            this.port = invokerLocator.getPort();
            this.hashCode = this.protocol.hashCode() * this.host.hashCode() * this.port;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ComparableHolder)) {
                return false;
            }
            ComparableHolder holder = (ComparableHolder)obj;
            return this.protocol.equals(holder.protocol.toLowerCase()) && this.host.equals(holder.host) && this.port == holder.port;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

