/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.ConnectorMBean;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.util.LocalHostUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Connector
implements MBeanRegistration,
ConnectorMBean {
    protected ServerInvoker invoker;
    private String locatorURI;
    private Element xml;
    private Map configuration = new HashMap();
    private MBeanServer server;
    private ServerSocketFactory svrSocketFactory;
    private SocketFactory socketFactory;
    private Connector marshallerLoaderConnector = null;
    private boolean isMarshallerLoader = false;
    private boolean isStarted = false;
    private boolean isCreated = false;
    protected final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$org$jboss$remoting$transport$Connector;

    public Connector() {
    }

    public Connector(String locatorURI) {
        this.locatorURI = locatorURI;
    }

    public Connector(InvokerLocator locator) {
        if (locator != null) {
            this.locatorURI = locator.getLocatorURI();
        }
    }

    public Connector(Map configuration) {
        this.configuration.putAll(configuration);
    }

    public Connector(String locatorURI, Map configuration) {
        this.locatorURI = locatorURI;
        this.configuration.putAll(configuration);
    }

    public Connector(InvokerLocator locator, Map configuration) {
        if (locator != null) {
            this.locatorURI = locator.getLocatorURI();
        }
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
    }

    protected Connector(boolean isMarshallerConnector) {
        this();
        this.isMarshallerLoader = isMarshallerConnector;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            if (!this.isCreated) {
                this.create();
            }
            this.configureHandlers();
            if (!this.isMarshallerLoader && this.marshallerLoaderConnector != null && !this.marshallerLoaderConnector.isStarted()) {
                this.marshallerLoaderConnector.start();
            }
            if (!this.invoker.isStarted()) {
                try {
                    this.invoker.start();
                }
                catch (Exception e) {
                    if (this.marshallerLoaderConnector != null) {
                        this.marshallerLoaderConnector.stop();
                    }
                    this.log.error((Object)"Error starting connector.", (Throwable)e);
                    throw e;
                }
            }
            this.isStarted = true;
            this.log.debug((Object)(this + " started"));
        }
    }

    public void start(boolean runAsNewThread) throws Exception {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Connector.this.start();
                }
                catch (Exception e) {
                    Connector.this.log.error((Object)"Error starting Connector.", (Throwable)e);
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(false);
        t.start();
    }

    private void init() throws Exception {
        HashMap invokerConfig = new HashMap();
        if (this.locatorURI == null) {
            if (this.xml != null) {
                this.getInvokerConfig(invokerConfig);
            }
            this.configuration.putAll(invokerConfig);
        }
        if (this.locatorURI == null) {
            throw new IllegalStateException("Connector not configured with LocatorURI.");
        }
        InvokerLocator locator = new InvokerLocator(this.locatorURI);
        if (this.invoker == null) {
            this.invoker = InvokerRegistry.createServerInvoker(locator, this.configuration);
            this.invoker.setMBeanServer(this.server);
            this.invoker.setServerSocketFactory(this.svrSocketFactory);
            this.svrSocketFactory = null;
            this.invoker.setSocketFactory(this.socketFactory);
            this.socketFactory = null;
            this.invoker.create();
        }
        if (this.server != null) {
            try {
                ObjectName objName = new ObjectName(this.invoker.getMBeanObjectName());
                if (!this.server.isRegistered(objName)) {
                    this.server.registerMBean(this.invoker, objName);
                } else {
                    this.log.warn((Object)(objName + " is already registered with MBeanServer"));
                }
            }
            catch (Throwable e) {
                this.log.warn((Object)("Error registering invoker " + this.invoker + " with MBeanServer."), e);
            }
        }
        this.locatorURI = this.invoker.getLocator().getLocatorURI();
        if (!this.isMarshallerLoader && this.marshallerLoaderConnector == null) {
            this.marshallerLoaderConnector = this.createMarshallerLoader(this.invoker.getLocator());
        }
    }

    private Connector createMarshallerLoader(InvokerLocator locator) {
        MarshalFactory.getMarshaller(locator, this.getClass().getClassLoader(), this.configuration);
        Connector marshallerLoader = null;
        InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
        if (loaderLocator != null) {
            List repositories = this.getLoaderRepositories();
            marshallerLoader = MarshallLoaderFactory.createMarshallLoader(loaderLocator, repositories, this.server);
        }
        return marshallerLoader;
    }

    private void getInvokerConfig(Map invokerConfig) {
        try {
            NodeList invokerNodes = this.xml.getElementsByTagName("invoker");
            if (invokerNodes != null && invokerNodes.getLength() >= 1) {
                Node invokerNode = invokerNodes.item(0);
                NamedNodeMap attributes = invokerNode.getAttributes();
                Node transportNode = attributes.getNamedItem("transport");
                if (transportNode != null) {
                    String host;
                    String transport = transportNode.getNodeValue();
                    if (invokerNodes.getLength() > 1) {
                        this.log.warn((Object)("Found more than one invokers defined in configuration.  Will only be using the first one - " + transport));
                    }
                    HashMap<String, String> paramConfig = new HashMap<String, String>();
                    NodeList invokerAttributes = invokerNode.getChildNodes();
                    int len = invokerAttributes.getLength();
                    for (int x = 0; x < len; ++x) {
                        Node attr = invokerAttributes.item(x);
                        if (!"attribute".equals(attr.getNodeName())) continue;
                        String name = attr.getAttributes().getNamedItem("name").getNodeValue();
                        String value = attr.getFirstChild().getNodeValue();
                        invokerConfig.put(name, value);
                        Node isParamAttribute = attr.getAttributes().getNamedItem("isParam");
                        if (isParamAttribute == null || !Boolean.valueOf(isParamAttribute.getNodeValue()).booleanValue()) continue;
                        paramConfig.put(name, value);
                    }
                    String clientConnectAddress = (String)invokerConfig.get("clientConnectAddress");
                    String clientConnectPort = (String)invokerConfig.get("clientConnectPort");
                    String serverBindAddress = (String)invokerConfig.get("serverBindAddress");
                    String serverBindPort = (String)invokerConfig.get("serverBindPort");
                    String path = (String)invokerConfig.get("path");
                    PortUtil.updateRange(invokerConfig);
                    String string = clientConnectAddress != null ? clientConnectAddress : (host = serverBindAddress != null ? serverBindAddress : LocalHostUtil.getLocalHost().getHostAddress());
                    int port = clientConnectPort != null ? Integer.parseInt(clientConnectPort) : (serverBindPort != null ? Integer.parseInt(serverBindPort) : PortUtil.findFreePort(serverBindAddress != null ? serverBindAddress : LocalHostUtil.getLocalHost().getHostAddress()));
                    String tempURI = transport + "://" + this.fixHostnameForURL(host) + ":" + port;
                    if (path != null) {
                        tempURI = tempURI + "/" + path;
                    }
                    if (paramConfig.size() > 0) {
                        Object value;
                        Object name;
                        tempURI = tempURI + "/?";
                        Iterator keyItr = paramConfig.keySet().iterator();
                        if (keyItr.hasNext()) {
                            name = keyItr.next();
                            value = paramConfig.get(name);
                            tempURI = tempURI + name + "=" + value;
                        }
                        while (keyItr.hasNext()) {
                            tempURI = tempURI + "&";
                            name = keyItr.next();
                            value = paramConfig.get(name);
                            tempURI = tempURI + name + "=" + value;
                        }
                    }
                    this.locatorURI = tempURI;
                } else {
                    this.log.error((Object)"Invoker element within Configuration attribute does not contain a transport attribute.");
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error configuring invoker for connector.", (Throwable)e);
            throw new IllegalStateException("Error configuring invoker for connector.  Can not continue without invoker.");
        }
    }

    private String fixHostnameForURL(String address) {
        if (address == null) {
            return address;
        }
        if (address.indexOf(58) != -1 && address.indexOf("[") == -1) {
            return "[" + address + "]";
        }
        return address;
    }

    private void configureHandlers() throws Exception {
        if (this.xml != null) {
            NodeList handlersNodes = this.xml.getElementsByTagName("handler");
            if (!(handlersNodes != null && handlersNodes.getLength() > 0 || this.getInvocationHandlers() != null && this.getInvocationHandlers().length != 0)) {
                throw new IllegalArgumentException("required 'handler' element not found and are no registered handlers found.");
            }
            int len = handlersNodes.getLength();
            for (int c = 0; c < len; ++c) {
                Node node = handlersNodes.item(c);
                Node subNode = node.getAttributes().getNamedItem("subsystem");
                if (subNode == null) {
                    throw new IllegalArgumentException("Required 'subsystem' attribute on 'handler' element");
                }
                String handlerClass = node.getFirstChild().getNodeValue();
                boolean isObjName = false;
                ServerInvocationHandler handler = null;
                try {
                    ObjectName objName = new ObjectName(handlerClass);
                    handler = this.createHandlerProxy(objName);
                    isObjName = true;
                }
                catch (MalformedObjectNameException e) {
                    this.log.debug((Object)"Handler supplied is not an object name.");
                }
                if (!isObjName) {
                    Class serverInvocationHandlerClass = ClassLoaderUtility.loadClass(handlerClass, class$org$jboss$remoting$transport$Connector == null ? Connector.class$("org.jboss.remoting.transport.Connector") : class$org$jboss$remoting$transport$Connector);
                    handler = (ServerInvocationHandler)serverInvocationHandlerClass.newInstance();
                }
                StringTokenizer tok = new StringTokenizer(subNode.getNodeValue(), ",");
                while (tok.hasMoreTokens()) {
                    String subsystem = tok.nextToken();
                    this.addInvocationHandler(subsystem, handler);
                }
            }
        }
    }

    private List getLoaderRepositories() {
        if (this.xml == null) {
            return null;
        }
        NodeList repositoryNodes = this.xml.getElementsByTagName("repository");
        if (repositoryNodes.getLength() == 0) {
            return null;
        }
        ArrayList<ObjectName> repositories = new ArrayList<ObjectName>();
        for (int i = 0; i < repositoryNodes.getLength(); ++i) {
            Node node = repositoryNodes.item(i);
            String repositoryName = node.getFirstChild().getNodeValue();
            try {
                ObjectName objName = new ObjectName(repositoryName);
                repositories.add(objName);
                this.log.info((Object)("repository: " + repositoryName));
                continue;
            }
            catch (MalformedObjectNameException e) {
                this.log.debug((Object)("repository name is not an object name: " + repositoryName));
            }
        }
        return repositories;
    }

    private ServerInvocationHandler createHandlerProxy(ObjectName objName) {
        if (this.server == null) {
            throw new RuntimeException("Can not register MBean invocation handler as the Connector has not been registered with a MBeanServer.");
        }
        ServerInvocationHandler handler = (ServerInvocationHandler)MBeanServerInvocationHandler.newProxyInstance(this.server, objName, ServerInvocationHandler.class, false);
        return handler;
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (this.invoker != null) {
            this.invoker.addConnectionListener(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        if (this.invoker != null) {
            this.invoker.removeConnectionListener(listener);
        }
    }

    public void setLeasePeriod(long leasePeriodValue) {
        if (this.invoker != null) {
            this.invoker.setLeasePeriod(leasePeriodValue);
        }
    }

    public long getLeasePeriod() {
        if (this.invoker != null) {
            return this.invoker.getLeasePeriod();
        }
        return -1L;
    }

    public void stop() {
        if (this.isStarted) {
            if (this.invoker != null) {
                if (this.server != null) {
                    try {
                        ObjectName objName = new ObjectName(this.invoker.getMBeanObjectName());
                        this.server.unregisterMBean(objName);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"invalid Object Name", (Throwable)e);
                    }
                }
                this.invoker.stop();
                this.invoker.destroy();
                InvokerRegistry.destroyServerInvoker(this.invoker);
                this.invoker = null;
            }
            if (this.marshallerLoaderConnector != null && this.marshallerLoaderConnector.isStarted) {
                this.marshallerLoaderConnector.stop();
                this.marshallerLoaderConnector = null;
            }
            this.isStarted = false;
        }
    }

    public void create() throws Exception {
        if (!this.isCreated) {
            try {
                this.init();
                this.isCreated = true;
            }
            catch (Exception e) {
                if (this.invoker != null) {
                    this.invoker.stop();
                    this.invoker.destroy();
                    InvokerRegistry.destroyServerInvoker(this.invoker);
                    this.invoker = null;
                }
                this.isCreated = false;
                throw e;
            }
        }
    }

    public void destroy() {
        if (this.isStarted) {
            this.stop();
        }
        if (this.invoker != null) {
            this.invoker.stop();
            this.invoker.destroy();
            InvokerRegistry.destroyServerInvoker(this.invoker);
            this.invoker = null;
        }
        this.isCreated = false;
    }

    public ServerInvoker getServerInvoker() {
        return this.invoker;
    }

    public ServerInvocationHandler[] getInvocationHandlers() {
        ServerInvocationHandler[] handlers = null;
        if (this.invoker != null) {
            handlers = this.invoker.getInvocationHandlers();
        }
        return handlers;
    }

    public InvokerLocator getLocator() {
        return this.invoker.getLocator();
    }

    public void setInvokerLocator(String locator) throws Exception {
        if (this.isCreated) {
            throw new RuntimeException("Can not set the invoker locator on this Connector as has already been created with a different locator.");
        }
        this.locatorURI = locator;
    }

    public String getInvokerLocator() throws Exception {
        return this.locatorURI;
    }

    public void setConfiguration(Element xml) throws Exception {
        this.xml = xml;
    }

    public Element getConfiguration() {
        return this.xml;
    }

    public ServerInvocationHandler addInvocationHandler(String subsystem, ObjectName handlerObjectName) throws Exception {
        ServerInvocationHandler invocationHandler = this.createHandlerProxy(handlerObjectName);
        return this.addInvocationHandler(subsystem, invocationHandler);
    }

    public ServerInvocationHandler addInvocationHandler(String subsystem, ServerInvocationHandler handler) throws Exception {
        if (this.invoker == null) {
            throw new IllegalStateException("You may only add handlers once the Connector is created (via create() method).");
        }
        handler.setMBeanServer(this.server);
        return this.invoker.addInvocationHandler(subsystem, handler);
    }

    public void removeInvocationHandler(String subsystem) throws Exception {
        ServerInvocationHandler handler = this.invoker.removeInvocationHandler(subsystem);
        if (handler != null) {
            handler.setMBeanServer(null);
        }
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        if (this.isCreated) {
            throw new RuntimeException("Can not set server socket factory on Connector after the create() method has been called.");
        }
        if (this.invoker != null) {
            this.invoker.setServerSocketFactory(serverSocketFactory);
        } else {
            this.svrSocketFactory = serverSocketFactory;
        }
    }

    public ServerSocketFactory getServerSocketFactory() {
        if (this.invoker != null) {
            return this.invoker.getServerSocketFactory();
        }
        return this.svrSocketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        if (this.isCreated) {
            throw new RuntimeException("Can not set socket factory on Connector after the create() method has been called.");
        }
        if (this.invoker != null) {
            this.invoker.setSocketFactory(socketFactory);
        } else {
            this.socketFactory = socketFactory;
        }
    }

    public SocketFactory getSocketFactory() {
        if (this.invoker != null) {
            return this.invoker.getSocketFactory();
        }
        return this.socketFactory;
    }
}

