/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.osgi.framework.resource.Requirement;

public class ResolutionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Requirement[] unresolvedRequirements;

    public ResolutionException(String message, Throwable cause, Collection<Requirement> unresolvedRequirements) {
        super(message, cause);
        if (unresolvedRequirements != null) {
            this.unresolvedRequirements = unresolvedRequirements.toArray(new Requirement[unresolvedRequirements.size()]);
        }
    }

    public ResolutionException(String message) {
        super(message);
    }

    public ResolutionException(Throwable cause) {
        super(cause);
    }

    public Collection<Requirement> getUnresolvedRequirements() {
        if (this.unresolvedRequirements == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(this.unresolvedRequirements.length);
        for (Requirement r : this.unresolvedRequirements) {
            requirements.add(r);
        }
        return requirements;
    }
}

