/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.v2.VersionRange;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.XIdentityRequirement;
import org.jboss.osgi.resolver.v2.spi.AbstractBundleRequirement;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

public class AbstractFragmentHostRequirement
extends AbstractBundleRequirement
implements XIdentityRequirement {
    private final String symbolicName = (String)this.getAttribute("osgi.wiring.host");
    private final VersionRange versionrange;

    protected AbstractFragmentHostRequirement(BundleRevision brev, Map<String, Object> atts, Map<String, String> dirs) {
        super(brev, "osgi.wiring.host", atts, dirs);
        Object versionatt = atts.get("bundle-version");
        if (versionatt instanceof String) {
            versionatt = VersionRange.parse((String)versionatt);
        }
        this.versionrange = (VersionRange)versionatt;
    }

    @Override
    protected List<String> getMandatoryAttributes() {
        return Arrays.asList("osgi.wiring.host");
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionrange;
    }

    @Override
    public boolean matches(BundleCapability cap) {
        Version version;
        if (!super.matches(cap)) {
            return false;
        }
        return this.versionrange == null || this.versionrange.isInRange(version = ((XIdentityCapability)((Object)cap)).getVersion());
    }
}

