/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.v2.XCapability;
import org.jboss.osgi.resolver.v2.XRequirement;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.spi.AbstractBundleRevision;
import org.jboss.osgi.resolver.v2.spi.AbstractResourceBuilder;
import org.jboss.osgi.resolver.v2.spi.URLBasedResource;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public abstract class XResourceBuilder {
    public static final Map<String, Object> EMPTY_ATTRIBUTES = Collections.emptyMap();
    public static final Map<String, String> EMPTY_DIRECTIVES = Collections.emptyMap();
    protected AbstractBundleRevision resource;

    protected XResourceBuilder() {
        this.resource = new AbstractBundleRevision();
    }

    protected XResourceBuilder(XResource resource) {
        this.resource = (AbstractBundleRevision)resource;
    }

    public static XResourceBuilder create() {
        return new AbstractResourceBuilder();
    }

    public static XResourceBuilder create(XResource resource) {
        return new AbstractResourceBuilder(resource);
    }

    public static XResourceBuilder create(URL baseURL, String contentPath) {
        URLBasedResource resource = new URLBasedResource(baseURL, contentPath);
        AbstractResourceBuilder builder = new AbstractResourceBuilder(resource){

            @Override
            public XCapability addIdentityCapability(String symbolicName, Version version, String type, Map<String, Object> atts, Map<String, String> dirs) {
                URLBasedResource urlres = (URLBasedResource)this.resource;
                atts.put("content.url", urlres.getContentURL());
                atts.put("content.path", urlres.getContentPath());
                return super.addIdentityCapability(symbolicName, version, type, atts, dirs);
            }
        };
        InputStream content = resource.getContent();
        try {
            Manifest manifest = new JarInputStream(content).getManifest();
            OSGiMetaData metaData = OSGiMetaDataBuilder.load((Manifest)manifest);
            builder.load(metaData);
        }
        catch (Exception ex) {
            URL contentURL = resource.getContentURL();
            throw new IllegalStateException("Cannot create capability from: " + contentURL, ex);
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException e) {}
            }
        }
        return builder;
    }

    public abstract XResourceBuilder load(OSGiMetaData var1) throws BundleException;

    public abstract XCapability addIdentityCapability(String var1, Version var2, String var3, Map<String, Object> var4, Map<String, String> var5);

    public abstract XRequirement addIdentityRequirement(String var1, Map<String, Object> var2, Map<String, String> var3);

    public abstract XCapability addFragmentHostCapability(String var1, Version var2, Map<String, Object> var3, Map<String, String> var4);

    public abstract XRequirement addFragmentHostRequirement(String var1, Map<String, Object> var2, Map<String, String> var3);

    public abstract XCapability addPackageCapability(String var1, Map<String, Object> var2, Map<String, String> var3);

    public abstract XRequirement addPackageRequirement(String var1, Map<String, Object> var2, Map<String, String> var3);

    public abstract XCapability addGenericCapability(String var1, Map<String, Object> var2, Map<String, String> var3);

    public abstract XRequirement addGenericRequirement(String var1, Map<String, Object> var2, Map<String, String> var3);

    public XResource getResource() {
        return this.resource;
    }
}

