/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.perf;

import io.narayana.perf.Measurement;
import io.narayana.perf.WorkerLifecycle;
import io.narayana.perf.WorkerWorkload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PerformanceProfileStore {
    public static final String BASE_DIRECTORY_PROPERTY = "performanceprofilestore.dir";
    private static final boolean DEFAULT_FAIL_ON_REGRESSION = false;
    public static final Float DEFAULT_VARIANCE = Float.valueOf(1.1f);
    public static final String PERFDATAFILENAME = "PerformanceProfileStore.last";
    public static final String PERFVARIANCEFILENAME = "PerformanceProfileStore.variance";
    public static final String PERFARGSFILENAME = "PerformanceProfileStore.args";
    public static final String PROPFILE_COMMENT = "Performance profile. Format is testName=value where value is the metric (throughput or duration)";
    private static final String BASE_DIR = System.getProperty("performanceprofilestore.dir");
    public static final String FAIL_ON_PERF_REGRESSION_PROP = "io.narayana.perf.failonregression";
    private static boolean failOnRegression = PerformanceProfileStore.isFailOnRegression();
    public static final String RESET_NETRICS_PROP = "io.narayana.perf.resetmetrics";
    public static final boolean resetMetrics = PerformanceProfileStore.isResetMetrics();
    private static final PerformanceProfileStore metrics = new PerformanceProfileStore();
    private Properties data;
    private Properties variances;
    private Properties testArgs;
    private File dataFile;
    private float _variance;

    public static boolean isResetMetrics() {
        return System.getProperty(RESET_NETRICS_PROP) == null ? false : Boolean.getBoolean(RESET_NETRICS_PROP);
    }

    public static boolean isFailOnRegression() {
        return System.getProperty(FAIL_ON_PERF_REGRESSION_PROP) == null ? false : Boolean.getBoolean(FAIL_ON_PERF_REGRESSION_PROP);
    }

    public static float getVariance() {
        return PerformanceProfileStore.metrics._variance;
    }

    public static float getVariance(String metricName) {
        if (!PerformanceProfileStore.metrics.variances.containsKey(metricName)) {
            return PerformanceProfileStore.metrics._variance;
        }
        return Float.parseFloat(PerformanceProfileStore.metrics.variances.getProperty(metricName));
    }

    private Properties loadProperties(String fileName) throws IOException {
        File file = new File(fileName);
        Properties p = new Properties();
        if (!file.exists()) {
            file.createNewFile();
        }
        FileInputStream is = new FileInputStream(file);
        p.load(is);
        ((InputStream)is).close();
        return p;
    }

    public PerformanceProfileStore() {
        if (!failOnRegression) {
            System.out.printf("PerformanceProfileStore: Regression checks are disabled%n", new Object[0]);
        }
        if (BASE_DIR == null) {
            System.out.printf("PerformanceProfileStore: Regression checks are disabled - performance test profile property %s not set%n", BASE_DIRECTORY_PROPERTY);
            this.data = new Properties();
            this.variances = new Properties();
            this.testArgs = new Properties();
            this._variance = DEFAULT_VARIANCE.floatValue();
        } else {
            try {
                String dataFileName = BASE_DIR + File.separator + PERFDATAFILENAME;
                this.data = this.loadProperties(dataFileName);
                this.variances = this.loadProperties(BASE_DIR + File.separator + PERFVARIANCEFILENAME);
                this.testArgs = this.loadProperties(BASE_DIR + File.separator + PERFARGSFILENAME);
                this._variance = Float.parseFloat(this.variances.getProperty("default", DEFAULT_VARIANCE.toString()));
                this.dataFile = new File(dataFileName);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load performance profile config - please check file paths", e);
            }
        }
    }

    public static Float getMetric(String metricName) {
        if (PerformanceProfileStore.metrics.data.containsKey(metricName)) {
            return Float.valueOf(Float.parseFloat(PerformanceProfileStore.metrics.data.getProperty(metricName, null)));
        }
        return null;
    }

    float getMetric(String name, float defaultValue) {
        return Float.parseFloat(this.data.getProperty(name, Float.toString(defaultValue)));
    }

    boolean updateMetric(StringBuilder info, String metricName, Float metricValue) {
        return this.updateMetric(info, this._variance, metricName, metricValue, false);
    }

    boolean updateMetric(StringBuilder info, String metricName, Float metricValue, boolean largerIsBetter) {
        return this.updateMetric(info, PerformanceProfileStore.getVariance(metricName), metricName, metricValue, largerIsBetter);
    }

    boolean updateMetric(StringBuilder info, float variance, String metricName, Float metricValue, boolean largerIsBetter) {
        Float canonicalValue = Float.valueOf(resetMetrics ? metricValue.floatValue() : this.getMetric(metricName, metricValue.floatValue()));
        boolean better = this.isBetter(metricValue, canonicalValue, largerIsBetter);
        if (!this.data.containsKey(metricName) || better || resetMetrics) {
            this.data.put(metricName, Float.toString(metricValue.floatValue()));
            if (BASE_DIR != null) {
                try {
                    this.data.store(new FileOutputStream(this.dataFile), PROPFILE_COMMENT);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot store performance data", e);
                }
            }
        }
        return this.isWithinTolerance(info, metricName, metricValue, canonicalValue, Float.valueOf(variance), largerIsBetter);
    }

    public static boolean checkPerformance(String metricName, float metricValue) {
        return PerformanceProfileStore.checkPerformance(metricName, metricValue, false);
    }

    public static boolean checkPerformance(String metricName, float metricValue, boolean largerIsBetter) {
        return metrics.updateMetric(null, PerformanceProfileStore.getVariance(metricName), metricName, Float.valueOf(metricValue), largerIsBetter);
    }

    public static boolean checkPerformance(StringBuilder info, String metricName, float metricValue, boolean largerIsBetter) {
        return metrics.updateMetric(info, PerformanceProfileStore.getVariance(metricName), metricName, Float.valueOf(metricValue), largerIsBetter);
    }

    boolean isWithinTolerance(StringBuilder info, String metricName, Float metricValue, Float canonicalValue, Float variance, boolean largerIsBetter) {
        Float headRoom = Float.valueOf(Math.abs(canonicalValue.floatValue() * (variance.floatValue() - 1.0f)));
        Float difference = Float.valueOf((metricValue.floatValue() - canonicalValue.floatValue()) / canonicalValue.floatValue() * 100.0f);
        boolean within = largerIsBetter ? metricValue.floatValue() >= canonicalValue.floatValue() - headRoom.floatValue() : metricValue.floatValue() <= canonicalValue.floatValue() + headRoom.floatValue();
        boolean ok = within || !failOnRegression;
        String s = String.format("%s %s: %f%% performance %s (%f versus %f) (variance=%f headroom=%f)", metricName, ok ? "Passed" : "Failed", difference, within ? "difference" : "regression", metricValue, canonicalValue, variance, headRoom);
        if (info != null) {
            info.append(s);
        } else {
            System.out.printf("%s%n", s);
        }
        return ok;
    }

    boolean isBetter(Float metricValue, Float canonicalValue, boolean largerIsBetter) {
        if (largerIsBetter) {
            return metricValue.floatValue() > canonicalValue.floatValue();
        }
        return metricValue.floatValue() < canonicalValue.floatValue();
    }

    public static <T> Measurement<T> regressionCheck(WorkerWorkload<T> workload, String metricName, boolean useConfigArgs, int warmUpCount, int numberOfCalls, int threadCount, int batchSize) {
        return PerformanceProfileStore.regressionCheck(null, workload, metricName, useConfigArgs, 0L, warmUpCount, numberOfCalls, threadCount, batchSize);
    }

    public static <T> Measurement<T> regressionCheck(WorkerWorkload<T> workload, String metricName, boolean useConfigArgs, long maxTestTime, int warmUpCount, int numberOfCalls, int threadCount, int batchSize) {
        return PerformanceProfileStore.regressionCheck(null, workload, metricName, useConfigArgs, maxTestTime, warmUpCount, numberOfCalls, threadCount, batchSize);
    }

    public static <T> Measurement<T> regressionCheck(WorkerLifecycle lifecycle, WorkerWorkload<T> workload, String metricName, boolean useConfigArgs, long maxTestTime, int warmUpCount, int numberOfCalls, int threadCount, int batchSize) {
        StringBuilder sb;
        Measurement opts;
        if (useConfigArgs) {
            String[] xargs = PerformanceProfileStore.getTestArgs(metricName);
            maxTestTime = PerformanceProfileStore.getArg(metricName, xargs, 0, maxTestTime, Long.class);
            warmUpCount = PerformanceProfileStore.getArg(metricName, xargs, 1, warmUpCount, Integer.class);
            numberOfCalls = PerformanceProfileStore.getArg(metricName, xargs, 2, numberOfCalls, Integer.class);
            threadCount = PerformanceProfileStore.getArg(metricName, xargs, 3, threadCount, Integer.class);
            batchSize = PerformanceProfileStore.getArg(metricName, xargs, 4, batchSize, Integer.class);
        }
        opts.setRegression(!PerformanceProfileStore.checkPerformance(sb = new StringBuilder(), metricName, (float)(opts = new Measurement<T>(maxTestTime, threadCount, numberOfCalls, batchSize).measure(lifecycle, workload)).getThroughput(), true));
        sb.append(String.format(" %d iterations using %d threads with a batch size of %d (warmup: %d error count: %d, tot millis: %d throughput: %f)", opts.getNumberOfCalls(), opts.getNumberOfThreads(), opts.getBatchSize(), opts.getNumberOfWarmupCalls(), opts.getNumberOfErrors(), opts.getTotalMillis(), opts.getThroughput()));
        opts.setInfo(sb.toString());
        return opts;
    }

    public static <T> T getArg(String metricName, String[] args, int index, T defaultValue, Class<T> argClass) {
        if (index >= 0 && index < args.length) {
            try {
                return argClass.getConstructor(String.class).newInstance(args[index]);
            }
            catch (Exception e) {
                throw new NullPointerException(metricName + ": found invalid test arguments in the PerformanceProfileStore: " + e.getMessage());
            }
        }
        return defaultValue;
    }

    public static String[] getTestArgs(String metricName) {
        String argsString = System.getProperty(metricName + ".args");
        if (argsString == null) {
            argsString = PerformanceProfileStore.metrics.testArgs.getProperty(metricName, "");
        }
        String[] args = argsString.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        list.removeAll(Collections.singleton(""));
        return list.toArray(new String[list.size()]);
    }

    public static Map<String, Float> getMatchingMetrics(String pattern) {
        HashMap<String, Float> matches = new HashMap<String, Float>();
        Enumeration<?> e = PerformanceProfileStore.metrics.data.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.matches(pattern)) continue;
            matches.put(key, Float.valueOf(PerformanceProfileStore.metrics.data.getProperty(key)));
        }
        return matches;
    }
}

