/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.perf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class RegressionChecker {
    public static final String BASE_DIRECTORY_PROPERTY = "performanceprofilestore.dir";
    public static final String RESET_NETRICS_PROP = "io.narayana.perf.resetmetrics";
    public static final String FAIL_ON_PERF_REGRESSION_PROP = "io.narayana.perf.failonregression";
    private static final String BASE_DIR = System.getProperty("performanceprofilestore.dir");
    public static final String PERF_ARGS_FILENAME = "PerformanceProfileStore.args";
    public static final String PERF_DATA_FILENAME = "PerformanceProfileStore.last";
    public static final String PERF_VAR_FILENAME = "PerformanceProfileStore.var";
    public static final String PROPFILE_COMMENT = "Performance profile. Format is testName=value where value is the metric (throughput or duration)";
    public static final Double DEFAULT_VARIANCE = 1.1;
    private static final boolean regressionChecksEnabled = RegressionChecker.readBooleanProperty("io.narayana.perf.failonregression");
    private String testHistoryFileName;
    private Properties testArgs;
    private Properties testHistory;
    private Properties testVariances;
    private boolean resetMetrics = RegressionChecker.readBooleanProperty("io.narayana.perf.resetmetrics");
    private boolean failOnRegression = regressionChecksEnabled;

    public static boolean isRegressionCheckEnabled() {
        return regressionChecksEnabled;
    }

    public RegressionChecker() throws IOException {
        this(BASE_DIR + File.separator + PERF_ARGS_FILENAME, BASE_DIR + File.separator + PERF_DATA_FILENAME, BASE_DIR + File.separator + PERF_VAR_FILENAME);
    }

    public RegressionChecker(String perfArgsFileName, String perfHistoryFileName, String perfVarFileName) throws IOException {
        this.testHistoryFileName = perfHistoryFileName;
        this.testArgs = this.loadProperties(perfArgsFileName);
        this.testHistory = this.loadProperties(perfHistoryFileName);
        this.testVariances = this.loadProperties(perfVarFileName);
    }

    public static Boolean readBooleanProperty(String propName) {
        return System.getProperty(propName) == null ? false : Boolean.getBoolean(propName);
    }

    public boolean isFailOnRegression() {
        return this.failOnRegression;
    }

    public boolean isResetMetrics() {
        return this.resetMetrics;
    }

    public void setFailOnRegression(boolean failOnRegression) {
        this.failOnRegression = failOnRegression;
    }

    public void setResetMetrics(boolean resetMetrics) {
        this.resetMetrics = resetMetrics;
    }

    private Properties loadProperties(String fileName) throws IOException {
        File file = new File(fileName);
        Properties p = new Properties();
        if (!file.exists()) {
            file.createNewFile();
        }
        FileInputStream is = new FileInputStream(file);
        p.load(is);
        ((InputStream)is).close();
        return p;
    }

    public <T> T getArg(String metricName, String[] args, int index, T defaultValue, Class<T> argClass) {
        if (index >= 0 && index < args.length) {
            try {
                return argClass.getConstructor(String.class).newInstance(args[index]);
            }
            catch (Exception e) {
                throw new NullPointerException(metricName + ": found invalid test arguments in the PerformanceProfileStore: " + e.getMessage());
            }
        }
        return defaultValue;
    }

    public String[] getTestArgs(String metricName) {
        String argsString = System.getProperty(metricName + ".args");
        if (argsString == null) {
            argsString = this.testArgs.getProperty(metricName, "");
        }
        String[] args = argsString.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        list.removeAll(Collections.singleton(""));
        return list.toArray(new String[list.size()]);
    }

    public Map<String, Double> getMatchingMetrics(String pattern) {
        HashMap<String, Double> matches = new HashMap<String, Double>();
        Enumeration<?> e = this.testHistory.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.matches(pattern)) continue;
            matches.put(key, Double.valueOf(this.testHistory.getProperty(key)));
        }
        return matches;
    }

    boolean isWithinTolerance(StringBuilder info, String metricName, double metricValue, double canonicalValue, double variance, boolean largerIsBetter) {
        double headRoom = Math.abs(canonicalValue * (variance - 1.0));
        double difference = (metricValue - canonicalValue) / canonicalValue * 100.0;
        boolean within = largerIsBetter ? metricValue >= canonicalValue - headRoom : metricValue <= canonicalValue + headRoom;
        String s = String.format("%s %s: %f%% performance %s (%f versus %f) (variance=%f headroom=%f)", metricName, within ? "Passed" : "Failed", difference, within ? "difference" : "regression", metricValue, canonicalValue, variance, headRoom);
        if (info != null) {
            info.append(s);
        } else {
            System.out.printf("%s%n", s);
        }
        return within;
    }

    boolean isBetter(double metricValue, double canonicalValue, boolean largerIsBetter) {
        if (largerIsBetter) {
            return metricValue > canonicalValue;
        }
        return metricValue < canonicalValue;
    }

    public double getVariance(String metricName) {
        if (!this.testVariances.containsKey(metricName)) {
            return DEFAULT_VARIANCE;
        }
        return Double.parseDouble(this.testVariances.getProperty(metricName));
    }

    double getMetric(String name, double defaultValue) {
        return Double.parseDouble(this.testHistory.getProperty(name, Double.toString(defaultValue)));
    }

    boolean updateMetric(StringBuilder info, String metricName, double metricValue, boolean largerIsBetter) {
        return this.updateMetric(info, this.getVariance(metricName), metricName, metricValue, largerIsBetter);
    }

    boolean updateMetric(StringBuilder info, double variance, String metricName, double metricValue, boolean largerIsBetter) {
        double canonicalValue = this.resetMetrics ? metricValue : this.getMetric(metricName, metricValue);
        boolean better = this.isBetter(metricValue, canonicalValue, largerIsBetter);
        if (!this.testHistory.containsKey(metricName) || better || this.resetMetrics) {
            this.testHistory.put(metricName, Double.toString(metricValue));
            if (this.failOnRegression && this.testHistoryFileName != null) {
                try {
                    this.testHistory.store(new FileOutputStream(this.testHistoryFileName), PROPFILE_COMMENT);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot store performance data", e);
                }
            }
        }
        return this.isWithinTolerance(info, metricName, metricValue, canonicalValue, variance, largerIsBetter);
    }
}

