/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceBuilder;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ReadableValueImpl;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.WritableValueImpl;
import org.jboss.msc.value.Value;

final class ServiceBuilderImpl<T>
extends AbstractServiceBuilder<T> {
    private final Thread thread = Thread.currentThread();
    private final Map<ServiceName, WritableValueImpl> provides = new HashMap<ServiceName, WritableValueImpl>();
    private Service service;
    private Set<ServiceName> aliases;
    private ServiceController.Mode initialMode;
    private Map<ServiceName, ReadableValueImpl> requires;
    private Set<StabilityMonitor> monitors;
    private Set<ServiceListener<? super T>> serviceListeners;
    private Set<LifecycleListener> lifecycleListeners;
    private boolean installed;

    ServiceBuilderImpl(ServiceName serviceId, ServiceTargetImpl serviceTarget, ServiceControllerImpl<?> parent) {
        super(serviceId, serviceTarget, parent);
        this.addProvidesInternal(serviceId, null);
    }

    @Override
    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(aliases);
        this.assertThreadSafety();
        this.assertServiceNotConfigured();
        for (ServiceName alias : aliases) {
            ServiceBuilderImpl.assertNotNull(alias);
            this.assertNotRequired(alias, false);
        }
        for (ServiceName alias : aliases) {
            if (alias.equals(this.getServiceId()) || !this.addAliasInternal(alias)) continue;
            this.addProvidesInternal(alias, null);
        }
        return this;
    }

    @Override
    public <V> Supplier<V> requires(ServiceName dependency) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(dependency);
        this.assertThreadSafety();
        this.assertServiceNotConfigured();
        this.assertNotInstanceId(dependency);
        this.assertNotRequired(dependency, true);
        this.assertNotProvided(dependency, true);
        ReadableValueImpl retVal = this.getServiceTarget().getOrCreateRegistration(dependency).getReadableValue();
        this.addRequiresInternal(dependency, retVal);
        return retVal;
    }

    @Override
    public <V> Consumer<V> provides(ServiceName ... dependencies) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(dependencies);
        this.assertThreadSafety();
        this.assertServiceNotConfigured();
        for (ServiceName dependency : dependencies) {
            ServiceBuilderImpl.assertNotNull(dependency);
            this.assertNotRequired(dependency, false);
            this.assertNotProvided(dependency, false);
        }
        WritableValueImpl retVal = new WritableValueImpl();
        for (ServiceName dependency : dependencies) {
            this.addProvidesInternal(dependency, retVal);
        }
        return retVal;
    }

    @Override
    public ServiceBuilder<T> setInstance(Service service) {
        this.assertNotInstalled();
        this.assertThreadSafety();
        this.assertServiceNotConfigured();
        this.service = service != null ? service : Service.NULL;
        return this;
    }

    @Override
    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull((Object)mode);
        ServiceBuilderImpl.assertNotRemove(mode);
        this.assertModeNotConfigured();
        this.assertThreadSafety();
        this.initialMode = mode;
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(monitor);
        this.assertThreadSafety();
        this.addMonitorInternal(monitor);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(LifecycleListener listener) {
        this.assertNotInstalled();
        ServiceBuilderImpl.assertNotNull(listener);
        this.assertThreadSafety();
        this.addListenerInternal(listener);
        return this;
    }

    @Override
    public ServiceController<T> install() throws ServiceRegistryException {
        this.assertNotInstalled();
        this.assertThreadSafety();
        this.installed = true;
        if (this.service == null) {
            this.service = Service.NULL;
        }
        if (this.initialMode == null) {
            this.initialMode = ServiceController.Mode.ACTIVE;
        }
        return this.getServiceTarget().install(this);
    }

    @Override
    void addServiceListenersNoCheck(Set<? extends ServiceListener<? super T>> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        if (this.serviceListeners == null) {
            this.serviceListeners = new IdentityHashSet<ServiceListener<? super T>>();
        }
        this.serviceListeners.addAll(listeners);
    }

    @Override
    void addLifecycleListenersNoCheck(Set<LifecycleListener> listeners) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (LifecycleListener listener : listeners) {
            if (listener == null) continue;
            this.addListenerInternal(listener);
        }
    }

    @Override
    void addMonitorsNoCheck(Collection<? extends StabilityMonitor> monitors) {
        for (StabilityMonitor stabilityMonitor : monitors) {
            if (stabilityMonitor == null) continue;
            this.addMonitorInternal(stabilityMonitor);
        }
    }

    @Override
    void addDependenciesNoCheck(Iterable<ServiceName> dependencies) {
        for (ServiceName dependency : dependencies) {
            if (dependency == null || this.requires != null && this.requires.containsKey(dependency) || this.provides != null && this.provides.containsKey(dependency)) continue;
            this.addRequiresInternal(dependency, null);
        }
    }

    @Override
    Service getService() {
        return this.service;
    }

    void addRequiresInternal(ServiceName name, ReadableValueImpl dependency) {
        if (this.requires == null) {
            this.requires = new HashMap<ServiceName, ReadableValueImpl>();
        }
        if (this.requires.size() == 16383) {
            throw new IllegalArgumentException("Too many dependencies specified (max is 16383)");
        }
        this.requires.put(name, dependency);
    }

    boolean addAliasInternal(ServiceName alias) {
        if (this.aliases == null) {
            this.aliases = new HashSet<ServiceName>();
        }
        if (!this.aliases.contains(alias)) {
            this.aliases.add(alias);
            return true;
        }
        return false;
    }

    void addProvidesInternal(ServiceName name, WritableValueImpl dependency) {
        if (dependency != null) {
            this.provides.put(name, dependency);
        } else if (!this.provides.containsKey(name)) {
            this.provides.put(name, null);
        }
    }

    void addMonitorInternal(StabilityMonitor monitor) {
        if (this.monitors == null) {
            this.monitors = new IdentityHashSet<StabilityMonitor>();
        }
        this.monitors.add(monitor);
    }

    void addListenerInternal(LifecycleListener listener) {
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new IdentityHashSet<LifecycleListener>();
        }
        this.lifecycleListeners.add(listener);
    }

    @Override
    Collection<ServiceName> getServiceAliases() {
        return this.aliases == null ? Collections.emptySet() : this.aliases;
    }

    @Override
    Map<ServiceName, WritableValueImpl> getProvides() {
        return this.provides;
    }

    @Override
    Map<ServiceName, AbstractServiceBuilder.Dependency> getDependencies() {
        if (this.requires == null) {
            return Collections.emptyMap();
        }
        HashMap<ServiceName, AbstractServiceBuilder.Dependency> retVal = new HashMap<ServiceName, AbstractServiceBuilder.Dependency>(this.requires.size());
        for (Map.Entry<ServiceName, ReadableValueImpl> entry : this.requires.entrySet()) {
            retVal.put(entry.getKey(), new AbstractServiceBuilder.Dependency(entry.getKey(), ServiceBuilder.DependencyType.REQUIRED));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<StabilityMonitor> getMonitors() {
        for (ServiceController<Object> parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ServiceControllerImpl<?> serviceControllerImpl = parent;
            synchronized (serviceControllerImpl) {
                this.addMonitorsNoCheck(parent.getMonitors());
                continue;
            }
        }
        return this.monitors == null ? Collections.emptySet() : this.monitors;
    }

    @Override
    Set<ServiceListener<? super T>> getServiceListeners() {
        return this.serviceListeners == null ? Collections.emptySet() : this.serviceListeners;
    }

    @Override
    Set<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners == null ? Collections.emptySet() : this.lifecycleListeners;
    }

    @Override
    ServiceController.Mode getInitialMode() {
        return this.initialMode;
    }

    @Override
    List<Injector<? super T>> getOutInjections() {
        return Collections.emptyList();
    }

    @Override
    List<ValueInjection<?>> getValueInjections() {
        return Collections.emptyList();
    }

    private void assertNotInstalled() {
        if (this.installed) {
            throw new IllegalStateException("ServiceBuilder already installed");
        }
    }

    private void assertProvidesCalled() {
        if (this.provides == null || this.provides.isEmpty()) {
            throw new IllegalStateException("ServiceBuilder.provides() must be called first");
        }
    }

    private void assertThreadSafety() {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("ServiceBuilder used by multiple threads");
        }
    }

    private void assertNotInstanceId(ServiceName dependency) {
        if (this.getServiceId().equals(dependency)) {
            throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
        }
    }

    private void assertNotRequired(ServiceName dependency, boolean processingRequires) {
        if (this.requires != null && this.requires.keySet().contains(dependency)) {
            if (processingRequires) {
                throw new IllegalArgumentException("Cannot require dependency more than once:" + dependency);
            }
            throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
        }
    }

    private void assertNotProvided(ServiceName dependency, boolean processingRequires) {
        if (this.provides == null) {
            return;
        }
        if (processingRequires) {
            if (this.provides.containsKey(dependency)) {
                throw new IllegalArgumentException("Cannot both require and provide same dependency:" + dependency);
            }
        } else if (this.provides.get(dependency) != null) {
            throw new IllegalArgumentException("Cannot provide dependency more than once: " + dependency);
        }
    }

    private void assertServiceNotConfigured() {
        if (this.service != null) {
            throw new IllegalStateException("Detected addAliases(), requires(), provides() or setService() call after setService() method call");
        }
    }

    private void assertModeNotConfigured() {
        if (this.initialMode != null) {
            throw new IllegalStateException("setInitialMode() method called twice");
        }
    }

    private static void assertNotNull(Object parameter) {
        if (parameter == null) {
            throw new NullPointerException("Method parameter cannot be null");
        }
    }

    private static void assertNotRemove(ServiceController.Mode mode) {
        if (mode == ServiceController.Mode.REMOVE) {
            throw new IllegalArgumentException("Initial service mode cannot be REMOVE");
        }
    }

    @Override
    public ServiceBuilder<T> addMonitors(StabilityMonitor ... monitors) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceName ... newDependencies) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... newDependencies) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addDependencies(Iterable<ServiceName> newDependencies) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> newDependencies) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addInjection(Injector<? super T> target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
        throw new UnsupportedOperationException();
    }
}

