/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.Lockable;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;

final class ServiceRegistrationImpl
extends Lockable
implements Dependency {
    private final ServiceContainerImpl container;
    private final ServiceName name;
    private final IdentityHashSet<Dependent> dependents = new IdentityHashSet(0);
    private ServiceControllerImpl<?> instance;
    private int demandedByCount;
    private int dependentsStartedCount;

    ServiceRegistrationImpl(ServiceContainerImpl container, ServiceName name) {
        this.container = container;
        this.name = name;
    }

    @Override
    public Lockable getLock() {
        return this;
    }

    IdentityHashSet<Dependent> getDependents() {
        return this.dependents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDependent(Dependent dependent) {
        assert (this.isWriteLocked());
        if (this.dependents.contains(dependent)) {
            throw new IllegalStateException("Dependent already exists on this registration");
        }
        this.dependents.add(dependent);
        if (this.instance == null) {
            dependent.dependencyUnavailable(this.name);
            return;
        }
        ServiceControllerImpl<?> serviceControllerImpl = this.instance;
        synchronized (serviceControllerImpl) {
            if (!this.instance.isInstallationCommitted()) {
                dependent.dependencyUnavailable(this.name);
                return;
            }
            this.instance.newDependent(this.name, dependent);
        }
    }

    @Override
    public void removeDependent(Dependent dependent) {
        assert (this.isWriteLocked());
        this.dependents.remove(dependent);
    }

    void setInstance(ServiceControllerImpl<?> newInstance) throws DuplicateServiceException {
        assert (newInstance != null);
        assert (this.isWriteLocked());
        if (this.instance != null) {
            throw new DuplicateServiceException(String.format("Service %s is already registered", this.name.getCanonicalName()));
        }
        this.instance = newInstance;
        if (this.demandedByCount > 0) {
            this.instance.addDemands(this.demandedByCount);
        }
        if (this.dependentsStartedCount > 0) {
            this.instance.dependentsStarted(this.dependentsStartedCount);
        }
    }

    void clearInstance(ServiceControllerImpl<?> oldInstance) {
        assert (oldInstance != null);
        assert (this.isWriteLocked());
        if (this.instance == oldInstance) {
            this.instance = null;
        }
    }

    ServiceContainerImpl getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() throws IllegalStateException {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (this.instance != null) {
                return this.instance.getValue();
            }
        }
        throw new IllegalStateException("Service is not installed");
    }

    @Override
    public ServiceName getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceControllerImpl<?> getDependencyController() {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            return this.instance;
        }
    }

    @Override
    public void dependentStarted() {
        assert (this.isWriteLocked());
        ++this.dependentsStartedCount;
        if (this.instance != null) {
            this.instance.dependentStarted();
        }
    }

    @Override
    public void dependentStopped() {
        assert (this.isWriteLocked());
        --this.dependentsStartedCount;
        if (this.instance != null) {
            this.instance.dependentStopped();
        }
    }

    @Override
    public void addDemand() {
        assert (this.isWriteLocked());
        ++this.demandedByCount;
        if (this.instance != null) {
            this.instance.addDemand();
        }
    }

    @Override
    public void removeDemand() {
        assert (this.isWriteLocked());
        --this.demandedByCount;
        if (this.instance != null) {
            this.instance.removeDemand();
        }
    }
}

