/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.lang.management.ManagementFactory;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.modules.AliasModuleSpec;
import org.jboss.modules.ConcreteModuleSpec;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.IterableModuleFinder;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Metrics;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadError;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.Version;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.management.DependencyInfo;
import org.jboss.modules.management.ModuleInfo;
import org.jboss.modules.management.ModuleLoaderMXBean;
import org.jboss.modules.management.ObjectProperties;
import org.jboss.modules.management.ResourceLoaderInfo;

public class ModuleLoader {
    private static final RuntimePermission ML_PERM = new RuntimePermission("canCreateModuleLoader");
    private static final RuntimePermission MODULE_REDEFINE_PERM = new RuntimePermission("canRedefineModule");
    private static final RuntimePermission MODULE_REDEFINE_ANY_PERM = new RuntimePermission("canRedefineAnyModule");
    private static final RuntimePermission MODULE_UNLOAD_ANY_PERM = new RuntimePermission("canUnloadAnyModule");
    private static final RuntimePermission MODULE_ITERATE_PERM = new RuntimePermission("canIterateModules");
    private static final AtomicInteger SEQ = new AtomicInteger(1);
    private static volatile MBeanReg REG_REF = new TempMBeanReg();
    public static final ModuleFinder[] NO_FINDERS = new ModuleFinder[0];
    private final ConcurrentMap<String, FutureModule> moduleMap = new ConcurrentHashMap<String, FutureModule>();
    private final ModuleFinder[] finders;
    private final boolean canRedefine;
    private final ModuleLoaderMXBean mxBean;
    private final AtomicLong linkTime = new AtomicLong();
    private final AtomicLong loadTime = new AtomicLong();
    private final AtomicLong classLoadTime = new AtomicLong();
    private final AtomicInteger scanCount = new AtomicInteger();
    private final AtomicInteger raceCount = new AtomicInteger();
    private final AtomicInteger classCount = new AtomicInteger();
    static final Object NOT_FOUND = new Object();

    ModuleLoader(boolean canRedefine, boolean skipRegister) {
        this(canRedefine, skipRegister, NO_FINDERS);
    }

    ModuleLoader(boolean canRedefine, boolean skipRegister, ModuleFinder[] finders) {
        this.canRedefine = canRedefine;
        this.finders = finders;
        this.mxBean = skipRegister ? null : AccessController.doPrivileged(new PrivilegedAction<ModuleLoaderMXBean>(){

            @Override
            public ModuleLoaderMXBean run() {
                ObjectName objectName;
                try {
                    objectName = new ObjectName("jboss.modules", ObjectProperties.properties(ObjectProperties.property("type", "ModuleLoader"), ObjectProperties.property("name", ModuleLoader.this.getClass().getSimpleName() + "-" + SEQ.incrementAndGet())));
                }
                catch (MalformedObjectNameException e) {
                    return null;
                }
                try {
                    MXBeanImpl mxBean = new MXBeanImpl(ModuleLoader.this, objectName);
                    REG_REF.addMBean(objectName, mxBean);
                    return mxBean;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        });
    }

    protected ModuleLoader() {
        this(NO_FINDERS);
    }

    public ModuleLoader(ModuleFinder[] finders) {
        this(ModuleLoader.checkPermissions(), false, ModuleLoader.safeClone(finders));
    }

    public ModuleLoader(ModuleFinder finder) {
        this(new ModuleFinder[]{finder});
    }

    private static ModuleFinder[] safeClone(ModuleFinder[] finders) {
        if (finders == null || finders.length == 0) {
            return NO_FINDERS;
        }
        for (ModuleFinder finder : finders = (ModuleFinder[])finders.clone()) {
            if (finder != null) continue;
            throw new IllegalArgumentException("Module finder cannot be null");
        }
        return finders;
    }

    private static boolean checkPermissions() {
        SecurityManager manager = System.getSecurityManager();
        if (manager == null) {
            return true;
        }
        manager.checkPermission(ML_PERM);
        try {
            manager.checkPermission(MODULE_REDEFINE_PERM);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static ModuleLoader forClass(Class<?> clazz) {
        Module module = Module.forClass(clazz);
        if (module == null) {
            return null;
        }
        return module.getModuleLoader();
    }

    public static ModuleLoader forClassLoader(ClassLoader classLoader) {
        Module module = Module.forClassLoader(classLoader, true);
        if (module == null) {
            return null;
        }
        return module.getModuleLoader();
    }

    public String toString() {
        return String.format("%s@%x for finders %s", this.getClass().getSimpleName(), this.hashCode(), Arrays.toString(this.finders));
    }

    public String getModuleDescription(Module module) {
        Version version = module.getVersion();
        return version == null ? module.getName() : module.getName() + "@" + String.valueOf(version);
    }

    public static void installMBeanServer() {
        REG_REF.installReal();
    }

    public final Module loadModule(String name) throws ModuleLoadException {
        Module module = this.preloadModule(name);
        if (module == null) {
            throw new ModuleNotFoundException(name);
        }
        module.relinkIfNecessary();
        return module;
    }

    public final Iterator<String> iterateModules(final String baseName, final boolean recursive) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MODULE_ITERATE_PERM);
        }
        return new Iterator<String>(this){
            int idx;
            Iterator<String> nested;
            final /* synthetic */ ModuleLoader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.nested == null) {
                        ModuleFinder finder;
                        if (this.idx == this.this$0.finders.length) {
                            return false;
                        }
                        if (!((finder = this.this$0.finders[this.idx++]) instanceof IterableModuleFinder)) continue;
                        this.nested = ((IterableModuleFinder)finder).iterateModules(baseName, recursive, this.this$0);
                        continue;
                    }
                    if (this.nested.hasNext()) break;
                    this.nested = null;
                }
                return true;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.nested.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected Module preloadModule(String name) throws ModuleLoadException {
        return this.loadModuleLocal(name);
    }

    protected Module preloadExportedModule(String name) throws ModuleLoadException {
        return this.preloadModule(name);
    }

    protected static Module preloadModule(String name, ModuleLoader moduleLoader) throws ModuleLoadException {
        return moduleLoader.preloadExportedModule(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Module loadModuleLocal(String name) throws ModuleLoadException {
        FutureModule futureModule = (FutureModule)this.moduleMap.get(name);
        if (futureModule != null) {
            return futureModule.getModule();
        }
        FutureModule newFuture = new FutureModule(name);
        futureModule = this.moduleMap.putIfAbsent(name, newFuture);
        if (futureModule != null) {
            return futureModule.getModule();
        }
        boolean ok = false;
        try {
            Module module;
            block16: {
                ModuleLogger log = Module.log;
                log.trace("Locally loading module %s from %s", (Object)name, (Object)this);
                long startTime = Metrics.getCurrentCPUTime();
                ModuleSpec moduleSpec = this.findModule(name);
                this.loadTime.addAndGet(Metrics.getCurrentCPUTime() - startTime);
                if (moduleSpec == null) {
                    log.trace("Module %s not found from %s", (Object)name, (Object)this);
                    Module module2 = null;
                    return module2;
                }
                if (!moduleSpec.getName().equals(name)) {
                    throw new ModuleLoadException("Module loader found a module with the wrong name");
                }
                if (moduleSpec instanceof AliasModuleSpec) {
                    AliasModuleSpec aliasModuleSpec = (AliasModuleSpec)moduleSpec;
                    while (true) {
                        Module aliasedModule;
                        if ((aliasedModule = this.loadModuleLocal(aliasModuleSpec.getAliasName())) == null) {
                            throw new ModuleLoadException("Alias module " + name + " is referencing not existing module");
                        }
                        Set<String> aliases = aliasedModule.aliases;
                        if (aliases == null) continue;
                        Set<String> set = aliases;
                        synchronized (set) {
                            if (aliases == aliasedModule.aliases) {
                                aliases.add(moduleSpec.getName());
                                module = aliasedModule;
                                newFuture.setModule(module);
                                log.trace("Added module %s as alias of %s from %s", (Object)moduleSpec.getName(), (Object)aliasModuleSpec.getAliasName(), (Object)this);
                                ok = true;
                                break block16;
                            }
                        }
                    }
                }
                module = this.defineModule((ConcreteModuleSpec)moduleSpec, newFuture);
                log.trace("Loaded module %s from %s", (Object)name, (Object)this);
                ok = true;
            }
            Module module3 = module;
            return module3;
        }
        finally {
            if (!ok) {
                newFuture.setModule(null);
                this.moduleMap.remove(name, newFuture);
            }
        }
    }

    protected final Module findLoadedModuleLocal(String name) {
        FutureModule futureModule = (FutureModule)this.moduleMap.get(name);
        if (futureModule != null) {
            try {
                return futureModule.getModule();
            }
            catch (ModuleNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    protected final void unloadModuleLocal(Module module) throws SecurityException {
        if (module == null) {
            throw new NullPointerException("Module parameter cannot be null");
        }
        this.unloadModuleLocal(module.getName(), module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean unloadModuleLocal(String moduleId, Module module) throws SecurityException {
        if (moduleId == null || module == null) {
            throw new NullPointerException("Method parameters cannot be null");
        }
        ModuleLoader moduleLoader = module.getModuleLoader();
        if (moduleLoader != this) {
            throw new SecurityException("Attempted to unload " + String.valueOf(module) + " from a different module loader");
        }
        FutureModule futureModule = (FutureModule)this.moduleMap.get(moduleId);
        if (futureModule != null && futureModule.module == module) {
            Set<String> aliases = module.aliases;
            if (aliases != null) {
                Set<String> set = aliases;
                synchronized (set) {
                    if (!aliases.remove(moduleId)) {
                        module.aliases = null;
                        for (String alias : aliases) {
                            this.moduleMap.remove(alias);
                        }
                    }
                }
            }
            return this.moduleMap.remove(moduleId, futureModule);
        }
        return false;
    }

    protected ModuleSpec findModule(String name) throws ModuleLoadException {
        for (ModuleFinder finder : this.finders) {
            ModuleSpec spec;
            if (finder == null || (spec = finder.findModule(name, this)) == null) continue;
            return spec;
        }
        return null;
    }

    protected final ModuleFinder[] getFinders() {
        return this.finders.length > 0 ? (ModuleFinder[])this.finders.clone() : NO_FINDERS;
    }

    private Module defineModule(final ConcreteModuleSpec moduleSpec, final FutureModule futureModule) throws ModuleLoadException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Module>(){
                final /* synthetic */ ModuleLoader this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Module run() {
                    ModuleLogger log = Module.log;
                    String name = moduleSpec.getName();
                    Module module = new Module(moduleSpec, this.this$0);
                    module.getClassLoaderPrivate().recalculate();
                    module.setDependencies(moduleSpec.getDependenciesInternal());
                    log.moduleDefined(name, this.this$0);
                    try {
                        futureModule.setModule(module);
                        return module;
                    }
                    catch (Error | RuntimeException e) {
                        log.trace(e, "Failed to load module %s", (Object)name);
                        throw e;
                    }
                }
            });
        }
        catch (PrivilegedActionException pe) {
            try {
                throw pe.getException();
            }
            catch (RuntimeException | ModuleLoadException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
    }

    protected void refreshResourceLoaders(Module module) {
        if (!this.canRedefine) {
            throw new SecurityException("Module redefinition requires canRedefineModule permission");
        }
        if (module.getModuleLoader() != this) {
            throw new SecurityException("Module is not defined by this module loader");
        }
        module.getClassLoaderPrivate().recalculate();
    }

    protected void setAndRefreshResourceLoaders(Module module, Collection<ResourceLoaderSpec> loaders) {
        if (!this.canRedefine) {
            throw new SecurityException("Module redefinition requires canRedefineModule permission");
        }
        if (module.getModuleLoader() != this) {
            throw new SecurityException("Module is not defined by this module loader");
        }
        module.getClassLoaderPrivate().setResourceLoaders((ResourceLoaderSpec[])loaders.toArray(ResourceLoaderSpec[]::new));
    }

    protected void relink(Module module) throws ModuleLoadException {
        if (!this.canRedefine) {
            throw new SecurityException("Module redefinition requires canRedefineModule permission");
        }
        if (module.getModuleLoader() != this) {
            throw new SecurityException("Module is not defined by this module loader");
        }
        module.relink();
    }

    protected void setAndRelinkDependencies(Module module, List<DependencySpec> dependencies) throws ModuleLoadException {
        if (!this.canRedefine) {
            throw new SecurityException("Module redefinition requires canRedefineModule permission");
        }
        if (module.getModuleLoader() != this) {
            throw new SecurityException("Module is not defined by this module loader");
        }
        module.setDependencies(dependencies);
        module.relinkIfNecessary();
    }

    protected DependencySpec[] getDependencies(Module module) {
        if (module.getModuleLoader() != this) {
            throw new SecurityException("Module is not defined by this module loader");
        }
        return (DependencySpec[])module.getDependencySpecsInternal().clone();
    }

    void addLinkTime(long amount) {
        if (amount != 0L) {
            this.linkTime.addAndGet(amount);
        }
    }

    void addClassLoadTime(long time) {
        if (time != 0L) {
            this.classLoadTime.addAndGet(time);
        }
    }

    void incScanCount() {
        if (Metrics.ENABLED) {
            this.scanCount.getAndIncrement();
        }
    }

    void incRaceCount() {
        if (Metrics.ENABLED) {
            this.raceCount.getAndIncrement();
        }
    }

    void incClassCount() {
        if (Metrics.ENABLED) {
            this.classCount.getAndIncrement();
        }
    }

    private static interface MBeanReg {
        public boolean addMBean(ObjectName var1, Object var2);

        public void removeMBean(ObjectName var1);

        public void installReal();
    }

    static final class FutureModule {
        final String name;
        volatile Object module;

        FutureModule(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Module getModule() throws ModuleNotFoundException {
            boolean intr = false;
            try {
                Object object;
                Object module = this.module;
                if (module == null) {
                    object = this;
                    synchronized (object) {
                        while ((module = this.module) == null) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                        }
                    }
                }
                if (module == NOT_FOUND) {
                    object = null;
                    return object;
                }
                object = (Module)module;
                return object;
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setModule(Module m) {
            FutureModule futureModule = this;
            synchronized (futureModule) {
                this.module = m == null ? NOT_FOUND : m;
                this.notifyAll();
            }
        }
    }

    private static final class TempMBeanReg
    implements MBeanReg {
        private final Map<ObjectName, Object> mappings = new LinkedHashMap<ObjectName, Object>();

        private TempMBeanReg() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addMBean(ObjectName name, Object bean) {
            if (bean == null) {
                throw new IllegalArgumentException("bean is null");
            }
            Class<ModuleLoader> clazz = ModuleLoader.class;
            synchronized (ModuleLoader.class) {
                if (REG_REF == this) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return this.mappings.put(name, bean) == null;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return REG_REF.addMBean(name, bean);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeMBean(ObjectName name) {
            Class<ModuleLoader> clazz = ModuleLoader.class;
            synchronized (ModuleLoader.class) {
                if (REG_REF == this) {
                    this.mappings.remove(name);
                } else {
                    REG_REF.removeMBean(name);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void installReal() {
            Class<ModuleLoader> clazz = ModuleLoader.class;
            synchronized (ModuleLoader.class) {
                RealMBeanReg real = new RealMBeanReg();
                if (REG_REF == this) {
                    REG_REF = real;
                    for (Map.Entry<ObjectName, Object> entry : this.mappings.entrySet()) {
                        real.addMBean(entry.getKey(), entry.getValue());
                    }
                    this.mappings.clear();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private static final class RealMBeanReg
    implements MBeanReg {
        private final MBeanServer server = AccessController.doPrivileged(ManagementFactory::getPlatformMBeanServer);

        RealMBeanReg() {
        }

        @Override
        public boolean addMBean(ObjectName name, Object bean) {
            try {
                this.server.registerMBean(bean, name);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        @Override
        public void removeMBean(ObjectName name) {
            try {
                this.server.unregisterMBean(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void installReal() {
        }
    }

    static final class MXBeanImpl
    implements ModuleLoaderMXBean {
        private static final Cleaner cleaner = Cleaner.create();
        private final WeakReference<ModuleLoader> reference;

        MXBeanImpl(ModuleLoader moduleLoader, ObjectName objectName) {
            cleaner.register(moduleLoader, () -> REG_REF.removeMBean(objectName));
            this.reference = new WeakReference<ModuleLoader>(moduleLoader);
        }

        @Override
        public String getDescription() {
            return this.getModuleLoader().toString();
        }

        @Override
        public long getLinkTime() {
            return this.getModuleLoader().linkTime.get();
        }

        @Override
        public long getLoadTime() {
            return this.getModuleLoader().loadTime.get();
        }

        @Override
        public long getClassDefineTime() {
            return this.getModuleLoader().classLoadTime.get();
        }

        @Override
        public int getScanCount() {
            return this.getModuleLoader().scanCount.get();
        }

        @Override
        public int getLoadedModuleCount() {
            return this.getModuleLoader().moduleMap.size();
        }

        @Override
        public int getRaceCount() {
            return this.getModuleLoader().raceCount.get();
        }

        @Override
        public int getClassCount() {
            return this.getModuleLoader().classCount.get();
        }

        @Override
        public List<String> queryLoadedModuleNames() {
            ModuleLoader loader = this.getModuleLoader();
            Set names = loader.moduleMap.keySet();
            ArrayList<String> list = new ArrayList<String>(names);
            list.sort(Comparator.naturalOrder());
            return list;
        }

        @Override
        public String dumpAllModuleInformation() {
            StringBuilder b = new StringBuilder();
            for (String name : this.queryLoadedModuleNames()) {
                this.doDumpModuleInformation(name, b);
            }
            return b.toString();
        }

        @Override
        public String dumpModuleInformation(String name) {
            StringBuilder b = new StringBuilder();
            this.doDumpModuleInformation(name, b);
            return b.toString();
        }

        private void doDumpModuleInformation(String name, StringBuilder b) {
            String mainClass;
            ModuleInfo description = this.getModuleDescription(name);
            b.append("Module ").append(name).append('\n');
            b.append("    Class loader: ").append(description.getClassLoader()).append('\n');
            String fallbackLoader = description.getFallbackLoader();
            if (fallbackLoader != null) {
                b.append("    Fallback loader: ").append(fallbackLoader).append('\n');
            }
            if ((mainClass = description.getMainClass()) != null) {
                b.append("    Main Class: ").append(mainClass).append('\n');
            }
            List<ResourceLoaderInfo> loaders = description.getResourceLoaders();
            b.append("    Resource Loaders:\n");
            for (ResourceLoaderInfo loader : loaders) {
                b.append("        Loader Type: ").append(loader.getType()).append('\n');
                b.append("        Paths:\n");
                for (String path : loader.getPaths()) {
                    b.append("            ").append(path).append('\n');
                }
            }
            b.append("    Dependencies:\n");
            for (DependencyInfo dependencyInfo : description.getDependencies()) {
                b.append("        Type: ").append(dependencyInfo.getDependencyType()).append('\n');
                String moduleName = dependencyInfo.getModuleName();
                if (moduleName != null) {
                    b.append("        Module Name: ").append(moduleName).append('\n');
                }
                if (dependencyInfo.isOptional()) {
                    b.append("        (optional)\n");
                }
                b.append("        Export Filter: ").append(dependencyInfo.getExportFilter()).append('\n');
                b.append("        Import Filter: ").append(dependencyInfo.getImportFilter()).append('\n');
                String localLoader = dependencyInfo.getLocalLoader();
                if (localLoader == null) continue;
                b.append("        Local Loader: ").append(localLoader).append('\n');
                b.append("        Paths:\n");
                for (String path : dependencyInfo.getLocalLoaderPaths()) {
                    b.append("            ").append(path).append('\n');
                }
            }
        }

        @Override
        public boolean unloadModule(String name) {
            ModuleLoader loader;
            Module module;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(MODULE_UNLOAD_ANY_PERM);
            }
            if ((module = (loader = this.getModuleLoader()).findLoadedModuleLocal(name)) == null) {
                return false;
            }
            loader.unloadModuleLocal(name, module);
            return true;
        }

        @Override
        public void refreshResourceLoaders(String name) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(MODULE_REDEFINE_ANY_PERM);
            }
            ModuleLoader loader = this.getModuleLoader();
            Module module = this.loadModule(name, loader);
            loader.refreshResourceLoaders(module);
        }

        @Override
        public void relink(String name) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(MODULE_REDEFINE_ANY_PERM);
            }
            ModuleLoader loader = this.getModuleLoader();
            Module module = this.loadModule(name, loader);
            try {
                loader.relink(module);
            }
            catch (ModuleLoadException e) {
                throw new IllegalStateException("Module load failure for module " + name + ": " + String.valueOf(e));
            }
        }

        @Override
        public List<DependencyInfo> getDependencies(String name) {
            ModuleLoader loader = this.getModuleLoader();
            Module module = this.loadModule(name, loader);
            return this.doGetDependencies(module);
        }

        private List<DependencyInfo> doGetDependencies(Module module) {
            Dependency[] dependencies = module.getDependenciesInternal();
            if (dependencies == null) {
                return Collections.emptyList();
            }
            ArrayList<DependencyInfo> list = new ArrayList<DependencyInfo>(dependencies.length);
            for (Dependency dependency : dependencies) {
                DependencyInfo info;
                String dependencyType = dependency.getClass().getSimpleName();
                String exportFilter = dependency.getExportFilter().toString();
                String importFilter = dependency.getImportFilter().toString();
                if (dependency instanceof LocalDependency) {
                    LocalDependency localDependency = (LocalDependency)dependency;
                    ArrayList<String> pathList = new ArrayList<String>(localDependency.getPaths());
                    Collections.sort(pathList);
                    info = new DependencyInfo(dependencyType, exportFilter, importFilter, null, null, false, localDependency.getLocalLoader().toString(), pathList);
                } else if (dependency instanceof ModuleDependency) {
                    ModuleDependency moduleDependency = (ModuleDependency)dependency;
                    info = new DependencyInfo(dependencyType, exportFilter, importFilter, moduleDependency.getModuleLoader().mxBean, moduleDependency.getName(), moduleDependency.isOptional(), null, null);
                } else {
                    info = new DependencyInfo(dependencyType, exportFilter, importFilter, null, null, false, null, null);
                }
                list.add(info);
            }
            return list;
        }

        @Override
        public List<ResourceLoaderInfo> getResourceLoaders(String name) {
            ModuleLoader loader = this.getModuleLoader();
            Module module = this.loadModule(name, loader);
            return this.doGetResourceLoaders(module);
        }

        private List<ResourceLoaderInfo> doGetResourceLoaders(Module module) {
            ModuleClassLoader classLoader = module.getClassLoaderPrivate();
            ResourceLoader[] loaders = classLoader.getResourceLoaders();
            ArrayList<ResourceLoaderInfo> list = new ArrayList<ResourceLoaderInfo>(loaders.length);
            for (ResourceLoader resourceLoader : loaders) {
                list.add(new ResourceLoaderInfo(resourceLoader.getClass().getName(), String.valueOf(resourceLoader.getLocation()), new ArrayList<String>(resourceLoader.getPaths())));
            }
            return list;
        }

        @Override
        public ModuleInfo getModuleDescription(String name) {
            ModuleLoader loader = this.getModuleLoader();
            Module module = this.loadModule(name, loader);
            List<DependencyInfo> dependencies = this.doGetDependencies(module);
            List<ResourceLoaderInfo> resourceLoaders = this.doGetResourceLoaders(module);
            LocalLoader fallbackLoader = module.getFallbackLoader();
            String fallbackLoaderString = fallbackLoader == null ? null : fallbackLoader.toString();
            return new ModuleInfo(module.getName(), module.getModuleLoader().mxBean, dependencies, resourceLoaders, module.getMainClass(), module.getClassLoaderPrivate().toString(), fallbackLoaderString);
        }

        @Override
        public SortedMap<String, List<String>> getModulePathsInfo(String name, boolean exports) {
            Map<String, List<LocalLoader>> paths;
            ModuleLoader loader = this.getModuleLoader();
            Module module = this.loadModule(name, loader);
            try {
                paths = module.getPathsUnchecked();
            }
            catch (ModuleLoadError e) {
                throw new IllegalArgumentException("Error loading module " + name + ": " + String.valueOf(e));
            }
            TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
            for (Map.Entry<String, List<LocalLoader>> entry : paths.entrySet()) {
                String path = entry.getKey();
                List<LocalLoader> loaders = entry.getValue();
                if (loaders.isEmpty()) {
                    result.put(path, Collections.emptyList());
                    continue;
                }
                if (loaders.size() == 1) {
                    result.put(path, Collections.singletonList(loaders.get(0).toString()));
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                for (LocalLoader localLoader : loaders) {
                    list.add(localLoader.toString());
                }
                result.put(path, list);
            }
            return result;
        }

        @Override
        public String getClassLocation(String moduleName, String className) {
            Class<?> clazz;
            ModuleLoader loader = this.getModuleLoader();
            Module module = this.loadModule(moduleName, loader);
            try {
                clazz = Class.forName(className, false, module.getClassLoaderPrivate());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            ProtectionDomain pd = clazz.getProtectionDomain();
            if (pd == null) {
                return null;
            }
            CodeSource cs = pd.getCodeSource();
            if (cs == null) {
                return null;
            }
            URL url = cs.getLocation();
            if (url == null) {
                return null;
            }
            return url.toString();
        }

        private Module loadModule(String name, ModuleLoader loader) {
            try {
                Module module = loader.findLoadedModuleLocal(name);
                if (module == null) {
                    throw new IllegalArgumentException("Module " + name + " not found");
                }
                return module;
            }
            catch (ModuleLoadError e) {
                throw new IllegalArgumentException("Error loading module " + name + ": " + String.valueOf(e));
            }
        }

        private ModuleLoader getModuleLoader() {
            ModuleLoader loader = (ModuleLoader)this.reference.get();
            if (loader == null) {
                throw new IllegalStateException("Module Loader is gone");
            }
            return loader;
        }
    }
}

