/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.IterableModuleFinder;
import org.jboss.modules.LayeredModulePathFactory;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.xml.ModuleXmlParser;

public final class LocalModuleFinder
implements IterableModuleFinder,
AutoCloseable {
    private static final File[] NO_FILES = new File[0];
    private final File[] repoRoots;
    private final PathFilter pathFilter;
    private final AccessControlContext accessControlContext;
    private final List<ResourceLoader> resourceLoaderList = new ArrayList<ResourceLoader>(64);
    private final ModuleXmlParser.ResourceRootFactory resourceRootFactory;
    private static final ResourceLoader TERMINATED_MARKER = new ResourceLoader(){

        @Override
        public String getRootName() {
            return null;
        }

        @Override
        public ClassSpec getClassSpec(String fileName) throws IOException {
            return null;
        }

        @Override
        public PackageSpec getPackageSpec(String name) throws IOException {
            return null;
        }

        @Override
        public Resource getResource(String name) {
            return null;
        }

        @Override
        public String getLibrary(String name) {
            return null;
        }

        @Override
        public Collection<String> getPaths() {
            return null;
        }
    };
    private static final Path MODULE_FILE_PATH = new File("module.xml").toPath();
    private static final Predicate<Path> ITER_FILTER = new Predicate<Path>(){

        @Override
        public boolean test(Path path) {
            Path fileName = path.getFileName();
            return fileName != null && fileName.equals(MODULE_FILE_PATH);
        }
    };

    private LocalModuleFinder(File[] repoRoots, PathFilter pathFilter, boolean cloneRoots) {
        this.repoRoots = cloneRoots && repoRoots.length > 0 ? (File[])repoRoots.clone() : repoRoots;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            for (File repoRoot : this.repoRoots) {
                if (repoRoot == null) continue;
                sm.checkPermission(new FilePermission(new File(repoRoot, "-").getPath(), "read"));
            }
        }
        this.pathFilter = pathFilter;
        this.accessControlContext = AccessController.getContext();
        this.resourceRootFactory = (rootPath, loaderPath, loaderName) -> {
            List<ResourceLoader> list;
            ResourceLoader loader = ModuleXmlParser.ResourceRootFactory.getDefault().createResourceLoader(rootPath, loaderPath, loaderName);
            List<ResourceLoader> list2 = list = this.resourceLoaderList;
            synchronized (list2) {
                if (list.size() == 1 && list.get(0) == TERMINATED_MARKER) {
                    LocalModuleFinder.safeClose(loader);
                    throw new IllegalStateException("Module finder is closed");
                }
                list.add(loader);
            }
            return loader;
        };
    }

    public LocalModuleFinder(File[] repoRoots, PathFilter pathFilter) {
        this(repoRoots, pathFilter, true);
    }

    public LocalModuleFinder(File[] repoRoots) {
        this(repoRoots, PathFilters.acceptAll());
    }

    public LocalModuleFinder() {
        this(true);
    }

    public LocalModuleFinder(boolean supportLayersAndAddOns) {
        this(LocalModuleFinder.getRepoRoots(supportLayersAndAddOns), PathFilters.acceptAll(), false);
    }

    static File[] getRepoRoots(boolean supportLayersAndAddOns) {
        return supportLayersAndAddOns ? LayeredModulePathFactory.resolveLayeredModulePath(LocalModuleFinder.getModulePathFiles()) : LocalModuleFinder.getModulePathFiles();
    }

    private static File[] getModulePathFiles() {
        return LocalModuleFinder.getFiles(System.getProperty("module.path", System.getenv("JAVA_MODULEPATH")), 0, 0);
    }

    private static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        if (modulePath == null) {
            return NO_FILES;
        }
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = LocalModuleFinder.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }

    @Override
    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
        String child = PathUtils.basicModuleNameToPath(name);
        if (child == null) {
            return null;
        }
        PathFilter pathFilter = this.pathFilter;
        if (pathFilter.accept(child + "/")) {
            try {
                return AccessController.doPrivileged(() -> LocalModuleFinder.parseModuleXmlFile(this.resourceRootFactory, name, delegateLoader, this.repoRoots), this.accessControlContext);
            }
            catch (PrivilegedActionException e) {
                try {
                    throw e.getCause();
                }
                catch (IOException e1) {
                    throw new ModuleLoadException(e1);
                }
                catch (Error | RuntimeException | ModuleLoadException e1) {
                    throw e1;
                }
                catch (Throwable t) {
                    throw new UndeclaredThrowableException(t);
                }
            }
        }
        return null;
    }

    public static ModuleSpec parseModuleXmlFile(String name, ModuleLoader delegateLoader, File ... roots) throws IOException, ModuleLoadException {
        return LocalModuleFinder.parseModuleXmlFile(ModuleXmlParser.ResourceRootFactory.getDefault(), name, delegateLoader, roots);
    }

    static ModuleSpec parseModuleXmlFile(ModuleXmlParser.ResourceRootFactory factory, String name, ModuleLoader delegateLoader, File ... roots) throws IOException, ModuleLoadException {
        String child = PathUtils.basicModuleNameToPath(name);
        if (child == null) {
            return null;
        }
        for (File root : roots) {
            File file = new File(root, child);
            File moduleXml = new File(file, "module.xml");
            if (!moduleXml.exists()) continue;
            ModuleSpec spec = ModuleXmlParser.parseModuleXml(factory, delegateLoader, name, file, moduleXml);
            if (spec == null) break;
            return spec;
        }
        return null;
    }

    @Override
    public Iterator<String> iterateModules(final String baseName, final boolean recursive, final ModuleLoader delegateLoader) {
        return new Iterator<String>(){
            private final Iterator<File> rootIter;
            private final Set<String> found;
            private Iterator<Path> pathIter;
            private String next;
            {
                this.rootIter = Arrays.asList(LocalModuleFinder.this.repoRoots).iterator();
                this.found = new HashSet<String>();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    while (this.pathIter == null) {
                        if (!this.rootIter.hasNext()) {
                            return false;
                        }
                        Path path = this.rootIter.next().toPath();
                        if (baseName != null && !baseName.isEmpty()) {
                            path = path.resolve(PathUtils.basicModuleNameToPath(baseName));
                        }
                        try {
                            this.pathIter = Files.walk(path, recursive ? Integer.MAX_VALUE : 1, new FileVisitOption[0]).filter(ITER_FILTER).iterator();
                        }
                        catch (IOException ignored) {
                            this.pathIter = null;
                        }
                    }
                    if (this.pathIter.hasNext()) {
                        Path nextPath = this.pathIter.next();
                        if (nextPath.getParent() == null) continue;
                        try {
                            InputStream stream = Files.newInputStream(nextPath, new OpenOption[0]);
                            try {
                                ModuleSpec moduleSpec = ModuleXmlParser.parseModuleXml(ModuleXmlParser.ResourceRootFactory.getDefault(), nextPath.getParent().toString(), stream, nextPath.toString(), delegateLoader, null);
                                if (moduleSpec == null) continue;
                                this.next = moduleSpec.getName();
                                if (this.found.add(this.next)) {
                                    boolean bl = true;
                                    return bl;
                                }
                                this.next = null;
                            }
                            finally {
                                if (stream == null) continue;
                                stream.close();
                            }
                        }
                        catch (IOException | ModuleLoadException exception) {}
                        continue;
                    }
                    this.pathIter = null;
                }
                return true;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    String string = this.next;
                    return string;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("local module finder @").append(Integer.toHexString(this.hashCode())).append(" (roots: ");
        int repoRootsLength = this.repoRoots.length;
        for (int i = 0; i < repoRootsLength; ++i) {
            File root = this.repoRoots[i];
            b.append(root);
            if (i == repoRootsLength - 1) continue;
            b.append(',');
        }
        b.append(')');
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<ResourceLoader> toClose;
        List<ResourceLoader> list = this.resourceLoaderList;
        List<ResourceLoader> list2 = list;
        synchronized (list2) {
            if (list.size() == 1 && list.get(0) == TERMINATED_MARKER) {
                return;
            }
            toClose = new ArrayList<ResourceLoader>(list);
            list.clear();
            list.add(TERMINATED_MARKER);
        }
        for (ResourceLoader resourceLoader : toClose) {
            LocalModuleFinder.safeClose(resourceLoader);
        }
    }

    private static void safeClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

