/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.modules.Resource;

final class URLConnectionResource
implements Resource {
    private final URLConnection connection;

    URLConnectionResource(URL url) throws IOException {
        this.connection = url.openConnection();
    }

    @Override
    public String getName() {
        return this.getURL().getPath();
    }

    @Override
    public URL getURL() {
        return this.connection.getURL();
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.connection.getInputStream();
    }

    @Override
    public long getSize() {
        long len = this.connection.getContentLengthLong();
        return len == -1L ? 0L : len;
    }
}

