/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.modules.MavenSettings;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.xml.MXParser;
import org.jboss.modules.xml.XmlPullParser;
import org.jboss.modules.xml.XmlPullParserException;

class MavenArtifactUtil {
    private static MavenSettings mavenSettings;
    private static final Object settingLoaderMutex;
    private static final Pattern snapshotPattern;
    private static final Object artifactLock;

    MavenArtifactUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MavenSettings getSettings() throws IOException {
        if (mavenSettings != null) {
            return mavenSettings;
        }
        Object object = settingLoaderMutex;
        synchronized (object) {
            String mavenHome;
            MavenSettings settings = new MavenSettings();
            Path m2 = Paths.get(System.getProperty("user.home"), ".m2");
            Path settingsPath = m2.resolve("settings.xml");
            if (Files.notExists(settingsPath, new LinkOption[0]) && (mavenHome = System.getenv("M2_HOME")) != null) {
                settingsPath = Paths.get(mavenHome, "conf", "settings.xml");
            }
            if (Files.exists(settingsPath, new LinkOption[0])) {
                MavenArtifactUtil.parseSettingsXml(settingsPath, settings);
            }
            if (settings.getLocalRepository() == null) {
                Path repository = m2.resolve("repository");
                settings.setLocalRepository(repository);
            }
            settings.resolveActiveSettings();
            mavenSettings = settings;
            return mavenSettings;
        }
    }

    private static MavenSettings parseSettingsXml(Path settings, MavenSettings mavenSettings) throws IOException {
        try {
            int eventType;
            MXParser reader = new MXParser();
            reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            InputStream source = Files.newInputStream(settings, StandardOpenOption.READ);
            reader.setInput(source, null);
            while ((eventType = reader.next()) != 1) {
                switch (eventType) {
                    case 2: {
                        switch (reader.getName()) {
                            case "settings": {
                                MavenArtifactUtil.parseSettings(reader, mavenSettings);
                            }
                        }
                    }
                }
            }
            return mavenSettings;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Could not parse maven settings.xml");
        }
    }

    private static void parseSettings(XmlPullParser reader, MavenSettings mavenSettings) throws XmlPullParserException, IOException {
        int eventType;
        block26: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    switch (reader.getName()) {
                        case "localRepository": {
                            String localRepository = reader.nextText();
                            if ("".equals(localRepository)) continue block26;
                            mavenSettings.setLocalRepository(Paths.get(localRepository, new String[0]));
                            continue block26;
                        }
                        case "profiles": {
                            while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                                switch (reader.getName()) {
                                    case "profile": {
                                        MavenArtifactUtil.parseProfile(reader, mavenSettings);
                                    }
                                }
                            }
                            continue block26;
                        }
                        case "activeProfiles": {
                            while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                                switch (reader.getName()) {
                                    case "activeProfile": {
                                        mavenSettings.addActiveProfile(reader.nextText());
                                    }
                                }
                            }
                            continue block26;
                        }
                    }
                    MavenArtifactUtil.skip(reader);
                    continue block26;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static void parseProfile(XmlPullParser reader, MavenSettings mavenSettings) throws XmlPullParserException, IOException {
        int eventType;
        MavenSettings.Profile profile = new MavenSettings.Profile();
        block14: while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
            switch (reader.getName()) {
                case "id": {
                    profile.setId(reader.nextText());
                    continue block14;
                }
                case "repositories": {
                    while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                        switch (reader.getName()) {
                            case "repository": {
                                MavenArtifactUtil.parseRepository(reader, profile);
                            }
                        }
                    }
                    continue block14;
                }
            }
            MavenArtifactUtil.skip(reader);
        }
        mavenSettings.addProfile(profile);
    }

    private static void parseRepository(XmlPullParser reader, MavenSettings.Profile profile) throws XmlPullParserException, IOException {
        int eventType;
        block6: while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
            switch (reader.getName()) {
                case "url": {
                    profile.addRepository(reader.nextText());
                    continue block6;
                }
            }
            MavenArtifactUtil.skip(reader);
        }
    }

    private static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File resolveJarArtifact(String qualifier) throws IOException {
        String[] split = qualifier.split(":");
        if (split.length < 3) {
            throw new IllegalArgumentException("Illegal artifact " + qualifier);
        }
        String groupId = split[0];
        String artifactId = split[1];
        String version = split[2];
        String classifier = "";
        if (split.length >= 4) {
            classifier = "-" + split[3];
        }
        String artifactRelativePath = MavenArtifactUtil.relativeArtifactPath(groupId, artifactId, version);
        String artifactRelativeHttpPath = MavenArtifactUtil.relativeArtifactHttpPath(groupId, artifactId, version);
        MavenSettings settings = MavenArtifactUtil.getSettings();
        Path localRepository = settings.getLocalRepository();
        Object object = artifactLock;
        synchronized (object) {
            String jarPath = artifactRelativePath + classifier + ".jar";
            Path fp = Paths.get(localRepository.toString(), jarPath);
            if (Files.exists(fp, new LinkOption[0])) {
                return fp.toFile();
            }
            List<String> remoteRepos = mavenSettings.getRemoteRepositories();
            if (remoteRepos.isEmpty()) {
                return null;
            }
            File jarFile = new File(localRepository.toFile(), jarPath);
            File pomFile = new File(localRepository.toFile(), artifactRelativePath + ".pom");
            for (String remoteRepository : remoteRepos) {
                try {
                    String remotePomPath = remoteRepository + artifactRelativeHttpPath + ".pom";
                    String remoteJarPath = remoteRepository + artifactRelativeHttpPath + classifier + ".jar";
                    MavenArtifactUtil.downloadFile(qualifier + ":pom", remotePomPath, pomFile);
                    MavenArtifactUtil.downloadFile(qualifier + ":jar", remoteJarPath, jarFile);
                    if (!jarFile.exists()) continue;
                    return jarFile;
                }
                catch (IOException e) {
                    Module.log.trace((Throwable)e, "Could not download '%s' from '%s' repository", (Object)artifactRelativePath, (Object)remoteRepository);
                }
            }
            Module.log.trace("Could not find in any remote repository");
            return null;
        }
    }

    public static String relativeArtifactPath(String groupId, String artifactId, String version) {
        return MavenArtifactUtil.relativeArtifactPath(File.separatorChar, groupId, artifactId, version);
    }

    public static String relativeArtifactHttpPath(String groupId, String artifactId, String version) {
        return MavenArtifactUtil.relativeArtifactPath('/', groupId, artifactId, version);
    }

    private static String relativeArtifactPath(char separator, String groupId, String artifactId, String version) {
        StringBuilder builder = new StringBuilder(groupId.replace('.', separator));
        builder.append(separator).append(artifactId).append(separator);
        Matcher versionMatcher = snapshotPattern.matcher(version);
        String pathVersion = versionMatcher.lookingAt() ? version.substring(0, versionMatcher.start()) + "-SNAPSHOT" : version;
        builder.append(pathVersion).append(separator).append(artifactId).append('-').append(version);
        return builder.toString();
    }

    public static void downloadFile(String artifact, String src, File dest) throws IOException {
        if (dest.exists()) {
            return;
        }
        URL url = new URL(src);
        URLConnection connection = url.openConnection();
        boolean message = Boolean.getBoolean("maven.download.message");
        try (InputStream bis = connection.getInputStream();){
            dest.getParentFile().mkdirs();
            if (message) {
                System.out.println("Downloading " + artifact);
            }
            Files.copy(bis, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    static {
        settingLoaderMutex = new Object();
        snapshotPattern = Pattern.compile("-\\d{8}\\.\\d+-\\d+$");
        artifactLock = new Object();
    }
}

