/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FileResourceLoader;
import org.jboss.modules.JDKPaths;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.JarModuleLoader;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.StreamUtil;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilters;

public final class JarModuleFinder
implements ModuleFinder {
    private final ModuleIdentifier myIdentifier;
    private final JarFile jarFile;

    public JarModuleFinder(ModuleIdentifier myIdentifier, JarFile jarFile) {
        this.myIdentifier = myIdentifier;
        this.jarFile = jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleSpec findModule(ModuleIdentifier identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        ModuleSpec moduleSpec;
        if (identifier.equals(this.myIdentifier)) {
            String[] dependencyEntries;
            String[] classPathEntries;
            Manifest manifest;
            try {
                manifest = this.jarFile.getManifest();
            }
            catch (IOException e) {
                throw new ModuleLoadException("Failed to load MANIFEST from JAR", e);
            }
            ModuleSpec.Builder builder = ModuleSpec.build(identifier);
            Attributes mainAttributes = manifest.getMainAttributes();
            String mainClass = mainAttributes.getValue(Attributes.Name.MAIN_CLASS);
            if (mainClass != null) {
                builder.setMainClass(mainClass);
            }
            String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
            String dependencies = mainAttributes.getValue("Dependencies");
            MultiplePathFilterBuilder pathFilterBuilder = PathFilters.multiplePathFilterBuilder(true);
            pathFilterBuilder.addFilter(PathFilters.is("modules"), false);
            pathFilterBuilder.addFilter(PathFilters.isChildOf("modules"), false);
            builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(new JarFileResourceLoader("", this.jarFile), pathFilterBuilder.create()));
            for (String entry : classPathEntries = classPath == null ? JarModuleLoader.NO_STRINGS : classPath.split("\\s+")) {
                JarFile childJarFile;
                File root;
                if (entry.isEmpty() || entry.startsWith("../") || entry.startsWith("./") || entry.startsWith("/") || entry.contains("/../")) continue;
                if (entry.endsWith("/")) {
                    root = new File(this.jarFile.getName(), entry);
                    FileResourceLoader resourceLoader = new FileResourceLoader(entry, root);
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(resourceLoader));
                    continue;
                }
                root = new File(this.jarFile.getName(), entry);
                try {
                    childJarFile = new JarFile(root, true);
                }
                catch (IOException e) {
                    continue;
                }
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(new JarFileResourceLoader(entry, childJarFile)));
            }
            for (String dependencyEntry : dependencyEntries = dependencies == null ? JarModuleLoader.NO_STRINGS : dependencies.split("\\s*,\\s*")) {
                String[] fields;
                boolean optional = false;
                boolean export = false;
                if ((dependencyEntry = dependencyEntry.trim()).isEmpty() || (fields = dependencyEntry.split("\\s+")).length < 1) continue;
                String moduleName = fields[0];
                for (int i = 1; i < fields.length; ++i) {
                    String field = fields[i];
                    if (field.equals("optional")) {
                        optional = true;
                        continue;
                    }
                    if (!field.equals("export")) continue;
                    export = true;
                }
                builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.fromString(moduleName), export, optional));
            }
            builder.addDependency(DependencySpec.createSystemDependencySpec(JDKPaths.JDK));
            builder.addDependency(DependencySpec.createLocalDependencySpec());
            return builder.create();
        }
        String namePath = identifier.getName().replace('.', '/');
        String basePath = "modules/" + namePath + "/" + identifier.getSlot();
        JarEntry moduleXmlEntry = this.jarFile.getJarEntry(basePath + "/module.xml");
        if (moduleXmlEntry == null) {
            return null;
        }
        try {
            InputStream inputStream = this.jarFile.getInputStream(moduleXmlEntry);
            try {
                moduleSpec = ModuleXmlParser.parseModuleXml(new ModuleXmlParser.ResourceRootFactory(){

                    @Override
                    public ResourceLoader createResourceLoader(String rootPath, String loaderPath, String loaderName) throws IOException {
                        return new JarFileResourceLoader(loaderName, JarModuleFinder.this.jarFile, loaderPath);
                    }
                }, basePath, inputStream, moduleXmlEntry.getName(), delegateLoader, identifier);
            }
            finally {
                StreamUtil.safeClose(inputStream);
            }
        }
        catch (IOException e) {
            throw new ModuleLoadException("Failed to read module.xml file", e);
        }
        return moduleSpec;
    }
}

