/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.PropertyReadAction;

final class JDKPaths {
    static final Set<String> JDK;

    private JDKPaths() {
    }

    private static void processClassPathItem(String classPath, Set<String> jarSet, Set<String> pathSet) {
        int e;
        if (classPath == null) {
            return;
        }
        int s = 0;
        do {
            String item;
            String string = item = (e = classPath.indexOf(File.pathSeparatorChar, s)) == -1 ? classPath.substring(s) : classPath.substring(s, e);
            if (!jarSet.contains(item)) {
                File file = new File(item);
                if (file.isDirectory()) {
                    JDKPaths.processDirectory0(pathSet, file);
                } else {
                    try {
                        JDKPaths.processJar(pathSet, file);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            s = e + 1;
        } while (e != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processJar(Set<String> pathSet, File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash == -1) continue;
                pathSet.add(name.substring(0, lastSlash));
            }
            zipFile.close();
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void processDirectory0(Set<String> pathSet, File file) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JDKPaths.processDirectory1(pathSet, entry, file.getPath());
                continue;
            }
            String parent = entry.getParent();
            if (parent == null) continue;
            pathSet.add(parent);
        }
    }

    static void processDirectory1(Set<String> pathSet, File file, String pathBase) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JDKPaths.processDirectory1(pathSet, entry, pathBase);
                continue;
            }
            String packagePath = entry.getParent();
            if (packagePath == null) continue;
            if ((packagePath = packagePath.substring(pathBase.length()).replace('\\', '/')).startsWith("/")) {
                packagePath = packagePath.substring(1);
            }
            pathSet.add(packagePath);
        }
    }

    static {
        FastCopyHashSet<String> pathSet = new FastCopyHashSet<String>(1024);
        FastCopyHashSet<String> jarSet = new FastCopyHashSet<String>(1024);
        String sunBootClassPath = AccessController.doPrivileged(new PropertyReadAction("sun.boot.class.path"));
        String javaClassPath = AccessController.doPrivileged(new PropertyReadAction("java.class.path"));
        JDKPaths.processClassPathItem(sunBootClassPath, jarSet, pathSet);
        JDKPaths.processClassPathItem(javaClassPath, jarSet, pathSet);
        pathSet.add("org/jboss/modules");
        pathSet.add("org/jboss/modules/filter");
        pathSet.add("org/jboss/modules/log");
        pathSet.add("org/jboss/modules/management");
        pathSet.add("org/jboss/modules/ref");
        JDK = Collections.unmodifiableSet(pathSet);
    }
}

