/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import org.jboss.modules.Module;
import org.jboss.modules.ref.Reaper;
import org.jboss.modules.ref.Reference;
import org.jboss.modules.ref.WeakReference;

public final class ModuleLocal<T> {
    private final int hashCode = System.identityHashCode(this);
    private static final Reaper<ModuleLocal<?>, Module> REAPER = new Reaper<ModuleLocal<?>, Module>(){

        @Override
        public void reap(Reference<ModuleLocal<?>, Module> reference) {
            reference.getAttachment().removeModuleLocal(reference);
        }
    };

    public boolean containedIn(Module module) {
        if (module == null) {
            throw ModuleLocal.moduleIsNull();
        }
        return module.containsModuleLocal(this);
    }

    public T get(Module module) {
        if (module == null) {
            throw ModuleLocal.moduleIsNull();
        }
        return module.getModuleLocal(this);
    }

    public T put(Module module, T value) {
        if (module == null) {
            throw ModuleLocal.moduleIsNull();
        }
        return module.putModuleLocal(new Ref(this, module), value);
    }

    public T putIfAbsent(Module module, T value) {
        if (module == null) {
            throw ModuleLocal.moduleIsNull();
        }
        return module.putModuleLocalIfAbsent(new Ref(this, module), value);
    }

    public T remove(Module module) {
        if (module == null) {
            throw ModuleLocal.moduleIsNull();
        }
        return module.removeModuleLocal(this);
    }

    public boolean remove(Module module, T expectedValue) {
        if (module == null) {
            throw ModuleLocal.moduleIsNull();
        }
        return module.removeModuleLocal(this, expectedValue);
    }

    public boolean replace(Module module, T expectedValue, T replacementValue) {
        if (module == null) {
            throw ModuleLocal.moduleIsNull();
        }
        return module.replaceModuleLocal(this, expectedValue, replacementValue);
    }

    public T replace(Module module, T newValue) {
        if (module == null) {
            throw ModuleLocal.moduleIsNull();
        }
        return module.replaceModuleLocal(this, newValue);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Ref && this.equals((Ref)obj);
    }

    boolean equals(Ref obj) {
        return this == obj.get();
    }

    private static IllegalArgumentException moduleIsNull() {
        return new IllegalArgumentException("module is null");
    }

    static final class Ref
    extends WeakReference<ModuleLocal<?>, Module> {
        private final int hashCode;

        Ref(ModuleLocal<?> value, Module module) {
            super(value, module, REAPER);
            this.hashCode = value.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ModuleLocal && this.equals((ModuleLocal)obj);
        }

        boolean equals(ModuleLocal<?> obj) {
            return this.get() == obj;
        }
    }
}

