/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.security.AccessController;
import java.util.jar.JarFile;
import org.jboss.modules.FileResourceLoader;
import org.jboss.modules.FilteredResourceLoader;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.filter.PathFilter;

public final class ResourceLoaders {
    static final boolean WRITE_INDEXES = Boolean.parseBoolean(AccessController.doPrivileged(new PropertyReadAction("jboss.modules.write-indexes", "true")));

    private ResourceLoaders() {
    }

    public static ResourceLoader createFileResourceLoader(String name, File root) {
        return new FileResourceLoader(name, root);
    }

    public static ResourceLoader createJarResourceLoader(String name, JarFile jarFile) {
        return new JarFileResourceLoader(name, jarFile);
    }

    public static ResourceLoader createFilteredResourceLoader(PathFilter pathFilter, ResourceLoader originalLoader) {
        return new FilteredResourceLoader(pathFilter, originalLoader);
    }
}

