/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.FileResourceLoader;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

final class ModuleXmlParser {
    private static final String NAMESPACE = "urn:jboss:module:1.0";
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();

    private ModuleXmlParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleSpec parseModuleXml(ModuleIdentifier moduleIdentifier, File root, File moduleInfoFile) throws ModuleLoadException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(moduleInfoFile);
        }
        catch (FileNotFoundException e) {
            throw new ModuleLoadException("No module.xml file found at " + moduleInfoFile);
        }
        try {
            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleXml(new ResourceRootFactory(){

                @Override
                public ResourceLoader createResourceLoader(String rootPath, String loaderPath, String loaderName) throws IOException {
                    File file = new File(rootPath, loaderPath);
                    if (file.isDirectory()) {
                        return new FileResourceLoader(loaderName, file);
                    }
                    return new JarFileResourceLoader(loaderName, new JarFile(file));
                }
            }, root.getPath(), fis, moduleInfoFile.getPath(), moduleIdentifier);
            return moduleSpec;
        }
        finally {
            ModuleXmlParser.safeClose(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleLoader parseModuleConfigXml(File moduleConfigFile) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(moduleConfigFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("No module-config.xml file found at " + moduleConfigFile);
        }
        try {
            ModuleLoader moduleLoader = ModuleXmlParser.parseModuleConfigXml(moduleConfigFile.getPath(), fis);
            return moduleLoader;
        }
        finally {
            ModuleXmlParser.safeClose(fis);
        }
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleSpec parseModuleXml(ResourceRootFactory factory, String rootPath, InputStream source, String moduleInfoFile, ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        ModuleSpec moduleSpec;
        XMLInputFactory inputFactory = INPUT_FACTORY;
        ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            moduleSpec = ModuleXmlParser.parseDocument(factory, rootPath, streamReader, ModuleSpec.build(moduleIdentifier));
        }
        catch (Throwable throwable) {
            try {
                ModuleXmlParser.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new ModuleLoadException("Error loading module from " + moduleInfoFile, e);
            }
        }
        ModuleXmlParser.safeClose(streamReader);
        return moduleSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleLoader parseModuleConfigXml(String configFilePath, InputStream source) {
        ModuleLoader moduleLoader;
        XMLInputFactory inputFactory = INPUT_FACTORY;
        ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            moduleLoader = ModuleXmlParser.parseConfigDocument(streamReader);
        }
        catch (Throwable throwable) {
            try {
                ModuleXmlParser.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new IllegalArgumentException("Error loading module configuration from " + configFilePath, e);
            }
        }
        ModuleXmlParser.safeClose(streamReader);
        return moduleLoader;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document", location);
    }

    private static XMLStreamException invalidModuleName(Location location, ModuleIdentifier expected) {
        return new XMLStreamException("Invalid/mismatched module name (expected " + expected + ")", location);
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    private static XMLStreamException noSuchLoader(XMLStreamReader reader, String loader) {
        return new XMLStreamException("No such loader found named '" + loader + "'", reader.getLocation());
    }

    private static XMLStreamException selfImport(XMLStreamReader reader, String loader) {
        return new XMLStreamException("Module loader '" + loader + "' imports itself", reader.getLocation());
    }

    private static XMLStreamException duplicateLoader(XMLStreamReader reader, String loader) {
        return new XMLStreamException("Multiple loaders defined named '" + loader + "'", reader.getLocation());
    }

    private static ModuleLoader parseConfigDocument(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 7: {
                    return ModuleXmlParser.parseConfigRootElement(reader);
                }
                case 1: {
                    if (Element.of(reader.getName()) != Element.CONFIGURATION) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    return ModuleXmlParser.parseConfigRootElementContents(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static ModuleLoader parseConfigRootElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    if (Element.of(reader.getName()) != Element.CONFIGURATION) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    return ModuleXmlParser.parseConfigRootElementContents(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static ModuleLoader parseConfigRootElementContents(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String defaultLoader = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.DEFAULT_LOADER);
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case DEFAULT_LOADER: {
                    defaultLoader = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty() || defaultLoader == null) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        HashMap<String, LocalModuleLoader> moduleLoaderMap = new HashMap<String, LocalModuleLoader>();
        HashMap<String, Set<String>> importsMap = new HashMap<String, Set<String>>();
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case LOADER: {
                            ModuleXmlParser.parseConfigLoaderElement(reader, moduleLoaderMap, importsMap);
                            continue block11;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 2: {
                    ModuleLoader loader = (ModuleLoader)moduleLoaderMap.get(defaultLoader);
                    if (loader == null) {
                        throw ModuleXmlParser.noSuchLoader(reader, defaultLoader);
                    }
                    for (Map.Entry entry : importsMap.entrySet()) {
                        String key = (String)entry.getKey();
                        Set value = (Set)entry.getValue();
                        LocalModuleLoader moduleLoader = (LocalModuleLoader)moduleLoaderMap.get(key);
                        assert (moduleLoader != null);
                        ModuleLoader[] importedLoaders = new ModuleLoader[value.size()];
                        int i = 0;
                        for (String importName : value) {
                            LocalModuleLoader importedLoader = (LocalModuleLoader)moduleLoaderMap.get(importName);
                            if (importedLoader == null) {
                                throw ModuleXmlParser.noSuchLoader(reader, importName);
                            }
                            if (importName.equals(key)) {
                                throw ModuleXmlParser.selfImport(reader, importName);
                            }
                            importedLoaders[i++] = importedLoader;
                        }
                        moduleLoader.setImportLoaders(importedLoaders);
                    }
                    return loader;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseConfigLoaderElement(XMLStreamReader reader, Map<String, LocalModuleLoader> map, Map<String, Set<String>> importsMap) throws XMLStreamException {
        HashSet<String> roots = new HashSet<String>();
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block11;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty() || name == null) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (map.containsKey(name)) {
            throw ModuleXmlParser.duplicateLoader(reader, name);
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE_PATH: {
                            ModuleXmlParser.parsePathName(reader, roots);
                            break;
                        }
                        case IMPORT: {
                            ModuleXmlParser.parsePathName(reader, imports);
                        }
                    }
                    continue block12;
                }
                case 2: {
                    File[] files = new File[roots.size()];
                    int i = 0;
                    for (String root : roots) {
                        files[i++] = new File(root);
                    }
                    map.put(name, new LocalModuleLoader(files));
                    importsMap.put(name, imports);
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static ModuleSpec parseDocument(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 7: {
                    ModuleXmlParser.parseRootElement(factory, rootPath, reader, specBuilder);
                    return specBuilder.create();
                }
                case 1: {
                    if (Element.of(reader.getName()) != Element.MODULE) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    ModuleXmlParser.parseModuleContents(factory, rootPath, reader, specBuilder);
                    ModuleXmlParser.parseEndDocument(reader);
                    return specBuilder.create();
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseRootElement(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    if (Element.of(reader.getName()) != Element.MODULE) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    ModuleXmlParser.parseModuleContents(factory, rootPath, reader, specBuilder);
                    ModuleXmlParser.parseEndDocument(reader);
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleContents(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block14;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block14;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (!specBuilder.getIdentifier().equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader.getLocation(), specBuilder.getIdentifier());
        }
        MultiplePathFilterBuilder exportsBuilder = PathFilters.multiplePathFilterBuilder(true);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    specBuilder.addDependency(DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), exportsBuilder.create()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EXPORTS: {
                            ModuleXmlParser.parseFilterList(reader, exportsBuilder);
                            continue block15;
                        }
                        case DEPENDENCIES: {
                            ModuleXmlParser.parseDependencies(reader, specBuilder);
                            continue block15;
                        }
                        case MAIN_CLASS: {
                            ModuleXmlParser.parseMainClass(reader, specBuilder);
                            continue block15;
                        }
                        case RESOURCES: {
                            ModuleXmlParser.parseResources(factory, rootPath, reader, specBuilder);
                            continue block15;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseDependencies(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case MODULE: {
                            ModuleXmlParser.parseModuleDependency(reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleDependency(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String name = null;
        String slot = null;
        boolean export = false;
        boolean optional = false;
        Disposition services = Disposition.NONE;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block15;
                }
                case SLOT: {
                    slot = reader.getAttributeValue(i);
                    continue block15;
                }
                case EXPORT: {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block15;
                }
                case SERVICES: {
                    services = Disposition.of(reader.getAttributeValue(i));
                    continue block15;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block15;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        MultiplePathFilterBuilder importBuilder = PathFilters.multiplePathFilterBuilder(true);
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder(export);
        block16: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    PathFilter importFilter;
                    if (services == Disposition.EXPORT) {
                        exportBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                    }
                    if (export) {
                        exportBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        exportBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    PathFilter exportFilter = exportBuilder.create();
                    if (importBuilder.isEmpty()) {
                        importFilter = services == Disposition.NONE ? PathFilters.getDefaultImportFilter() : PathFilters.getDefaultImportFilterWithServices();
                    } else {
                        if (services != Disposition.NONE) {
                            importBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                        }
                        importBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        importBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                        importFilter = importBuilder.create();
                    }
                    specBuilder.addDependency(DependencySpec.createModuleDependencySpec(importFilter, exportFilter, null, ModuleIdentifier.create(name, slot), optional));
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case EXPORTS: {
                            ModuleXmlParser.parseFilterList(reader, exportBuilder);
                            continue block16;
                        }
                        case IMPORTS: {
                            ModuleXmlParser.parseFilterList(reader, importBuilder);
                            continue block16;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseMainClass(XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        specBuilder.setMainClass(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseResources(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case RESOURCE_ROOT: {
                            ModuleXmlParser.parseResourceRoot(factory, rootPath, reader, specBuilder);
                            continue block7;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseResourceRoot(ResourceRootFactory factory, String rootPath, XMLStreamReader reader, ModuleSpec.Builder specBuilder) throws XMLStreamException {
        String name = null;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block13;
                }
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block13;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        if (name == null) {
            name = path;
        }
        MultiplePathFilterBuilder filterBuilder = PathFilters.multiplePathFilterBuilder(true);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    ResourceLoader resourceLoader;
                    try {
                        resourceLoader = factory.createResourceLoader(rootPath, path, name);
                    }
                    catch (IOException e) {
                        throw new XMLStreamException(String.format("Failed to add resource root '%s' at path '%s'", name, path), reader.getLocation(), e);
                    }
                    specBuilder.addResourceRoot(new ResourceLoaderSpec(resourceLoader, filterBuilder.create()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (!encountered.add(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    switch (element) {
                        case FILTER: {
                            ModuleXmlParser.parseFilterList(reader, filterBuilder);
                            continue block14;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseFilterList(XMLStreamReader reader, MultiplePathFilterBuilder builder) throws XMLStreamException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case INCLUDE: {
                            ModuleXmlParser.parsePath(reader, true, builder);
                            continue block10;
                        }
                        case EXCLUDE: {
                            ModuleXmlParser.parsePath(reader, false, builder);
                            continue block10;
                        }
                        case INCLUDE_SET: {
                            ModuleXmlParser.parseSet(reader, true, builder);
                            continue block10;
                        }
                        case EXCLUDE_SET: {
                            ModuleXmlParser.parseSet(reader, false, builder);
                            continue block10;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parsePath(XMLStreamReader reader, boolean include, MultiplePathFilterBuilder builder) throws XMLStreamException {
        boolean literal;
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                builder.addFilter(PathFilters.isChildOf(path), include);
            } else {
                builder.addFilter(PathFilters.is(path), include);
            }
        } else {
            builder.addFilter(PathFilters.match(path), include);
        }
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseSet(XMLStreamReader reader, boolean include, MultiplePathFilterBuilder builder) throws XMLStreamException {
        FastCopyHashSet<String> set = new FastCopyHashSet<String>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addFilter(PathFilters.in(set), include);
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case PATH: {
                            ModuleXmlParser.parsePathName(reader, set);
                        }
                    }
                }
            }
        }
    }

    private static void parsePathName(XMLStreamReader reader, Set<String> set) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        set.add(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseEndDocument(XMLStreamReader reader) throws XMLStreamException {
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 8: {
                    return;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block5;
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 5: 
                case 6: {
                    continue block5;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    static enum Disposition {
        NONE("none"),
        IMPORT("import"),
        EXPORT("export");

        private static final Map<String, Disposition> values;
        private final String value;

        private Disposition(String value) {
            this.value = value;
        }

        static Disposition of(String value) {
            Disposition disposition = values.get(value);
            return disposition == null ? NONE : disposition;
        }

        static {
            HashMap<String, Disposition> map = new HashMap<String, Disposition>();
            for (Disposition d : Disposition.values()) {
                map.put(d.value, d);
            }
            values = map;
        }
    }

    static enum Attribute {
        NAME,
        SLOT,
        EXPORT,
        SERVICES,
        PATH,
        OPTIONAL,
        DEFAULT_LOADER,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("slot"), SLOT);
            attributesMap.put(new QName("export"), EXPORT);
            attributesMap.put(new QName("services"), SERVICES);
            attributesMap.put(new QName("path"), PATH);
            attributesMap.put(new QName("optional"), OPTIONAL);
            attributesMap.put(new QName("default-loader"), DEFAULT_LOADER);
            attributes = attributesMap;
        }
    }

    static enum Element {
        MODULE,
        DEPENDENCIES,
        EXPORTS,
        IMPORTS,
        INCLUDE,
        INCLUDE_SET,
        EXCLUDE,
        EXCLUDE_SET,
        RESOURCES,
        MAIN_CLASS,
        RESOURCE_ROOT,
        PATH,
        FILTER,
        CONFIGURATION,
        LOADER,
        MODULE_PATH,
        IMPORT,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            Element element = elements.get(qName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "module"), MODULE);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "dependencies"), DEPENDENCIES);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "resources"), RESOURCES);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "main-class"), MAIN_CLASS);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "resource-root"), RESOURCE_ROOT);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "path"), PATH);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "exports"), EXPORTS);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "imports"), IMPORTS);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "include"), INCLUDE);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "exclude"), EXCLUDE);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "include-set"), INCLUDE_SET);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "exclude-set"), EXCLUDE_SET);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "filter"), FILTER);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "configuration"), CONFIGURATION);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "loader"), LOADER);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "module-path"), MODULE_PATH);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "import"), IMPORT);
            elements = elementsMap;
        }
    }

    static interface ResourceRootFactory {
        public ResourceLoader createResourceLoader(String var1, String var2, String var3) throws IOException;
    }
}

