/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.HashMap;
import java.util.Map;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

public final class ClassifyingModuleLoader
extends ModuleLoader {
    private volatile Map<String, ModuleLoader> delegates;
    private final ModuleLoader defaultLoader;
    private final String name;

    public ClassifyingModuleLoader(String name, Map<String, ModuleLoader> delegates, ModuleLoader defaultLoader) {
        super(0);
        this.defaultLoader = defaultLoader;
        this.delegates = new HashMap<String, ModuleLoader>(delegates);
        this.name = name;
    }

    @Override
    protected Module preloadModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        String name = moduleIdentifier.getName();
        Map<String, ModuleLoader> delegates = this.delegates;
        ModuleLoader loader;
        while ((loader = delegates.get(name)) == null) {
            int idx = name.lastIndexOf(46);
            if (idx == -1) {
                return ClassifyingModuleLoader.preloadModule(moduleIdentifier, this.defaultLoader);
            }
            name = name.substring(0, idx);
        }
        return ClassifyingModuleLoader.preloadModule(moduleIdentifier, loader);
    }

    @Override
    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        return null;
    }

    public void setDelegates(Map<String, ModuleLoader> delegates) {
        this.delegates = new HashMap<String, ModuleLoader>(delegates);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

