/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.SystemLocalLoader;

public final class SystemModuleLoader
extends ModuleLoader {
    static final SystemModuleLoader INSTANCE = new SystemModuleLoader();

    public static SystemModuleLoader getInstance() {
        return INSTANCE;
    }

    @Override
    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        if (!moduleIdentifier.equals(ModuleIdentifier.SYSTEM)) {
            return null;
        }
        SystemLocalLoader systemLocalLoader = SystemLocalLoader.getInstance();
        ModuleSpec.Builder builder = ModuleSpec.build(ModuleIdentifier.SYSTEM);
        builder.addDependency(DependencySpec.createLocalDependencySpec(systemLocalLoader, systemLocalLoader.getPathSet(), true));
        return builder.create();
    }

    @Override
    public String toString() {
        return "system";
    }
}

