/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Queue;

public abstract class ConcurrentClassLoader
extends SecureClassLoader {
    protected static final Enumeration<URL> EMPTY_ENUMERATION = Collections.enumeration(Collections.emptySet());

    @Override
    public final Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, false, false);
    }

    @Override
    public final Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, false, resolve);
    }

    public final Class<?> loadExportedClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, true, false);
    }

    public final Class<?> loadExportedClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, true, resolve);
    }

    protected Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        throw new ClassNotFoundException(className);
    }

    @Override
    protected final Class<?> findClass(String className) throws ClassNotFoundException {
        return this.findClass(className, false, false);
    }

    @Override
    public final URL getResource(String name) {
        if (name.startsWith("java/")) {
            return super.getResource(name);
        }
        return this.findResource(name, false);
    }

    @Override
    public final Enumeration<URL> getResources(String name) throws IOException {
        if (name.startsWith("java/")) {
            return super.getResources(name);
        }
        return this.findResources(name, false);
    }

    protected URL findResource(String name, boolean exportsOnly) {
        return null;
    }

    @Override
    protected final URL findResource(String name) {
        return null;
    }

    protected Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return EMPTY_ENUMERATION;
    }

    @Override
    protected final Enumeration<URL> findResources(String name) {
        return EMPTY_ENUMERATION;
    }

    protected InputStream findResourceAsStream(String name, boolean exportsOnly) {
        URL url = this.findResource(name, exportsOnly);
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final InputStream getResourceAsStream(String name) {
        if (name.startsWith("java/")) {
            return super.getResourceAsStream(name);
        }
        return this.findResourceAsStream(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> performLoadClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (className.startsWith("java.") || className.startsWith("sun.reflect.")) {
            return this.findSystemClass(className);
        }
        if (Thread.holdsLock(this) && Thread.currentThread() != LoaderThreadHolder.LOADER_THREAD) {
            LoadRequest req = new LoadRequest(className, resolve, exportsOnly, this);
            Queue<LoadRequest> queue = LoaderThreadHolder.REQUEST_QUEUE;
            Queue<LoadRequest> queue2 = LoaderThreadHolder.REQUEST_QUEUE;
            synchronized (queue2) {
                queue.add(req);
                queue.notify();
            }
            boolean intr = false;
            try {
                while (!req.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
            return req.result;
        }
        return this.findClass(className, exportsOnly, resolve);
    }

    static class LoaderThread
    extends Thread {
        LoaderThread() {
        }

        @Override
        public void interrupt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Package.getPackages();
            Queue<LoadRequest> queue = LoaderThreadHolder.REQUEST_QUEUE;
            while (true) {
                try {
                    while (true) {
                        LoadRequest request;
                        Queue<LoadRequest> queue2 = queue;
                        synchronized (queue2) {
                            while ((request = queue.poll()) == null) {
                                queue.wait();
                            }
                        }
                        ConcurrentClassLoader loader = request.requester;
                        Class result = null;
                        ConcurrentClassLoader concurrentClassLoader = loader;
                        synchronized (concurrentClassLoader) {
                            try {
                                result = loader.performLoadClass(request.className, request.exportsOnly, request.resolve);
                            }
                            finally {
                                request.result = result;
                                request.done = true;
                                loader.notifyAll();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }

    static class LoadRequest {
        private final String className;
        private final boolean resolve;
        private final ConcurrentClassLoader requester;
        Class<?> result;
        private boolean exportsOnly;
        boolean done;

        LoadRequest(String className, boolean resolve, boolean exportsOnly, ConcurrentClassLoader requester) {
            this.className = className;
            this.resolve = resolve;
            this.exportsOnly = exportsOnly;
            this.requester = requester;
        }
    }

    protected static final class LoaderThreadHolder {
        static final Thread LOADER_THREAD;
        static final Queue<LoadRequest> REQUEST_QUEUE;

        private LoaderThreadHolder() {
        }

        static {
            REQUEST_QUEUE = new ArrayDeque<LoadRequest>();
            LoaderThread thr = new LoaderThread();
            thr.setName("ClassLoader Thread");
            thr.setDaemon(true);
            thr.start();
            LOADER_THREAD = thr;
        }
    }
}

