/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.Resource;
import org.jboss.modules.URLResource;

final class SystemLocalLoader
implements LocalLoader {
    private final Set<String> pathSet;
    private static final SystemLocalLoader INSTANCE = new SystemLocalLoader();
    private static final ClassLoader SYSTEM_CL = SystemLocalLoader.class.getClassLoader();

    private SystemLocalLoader() {
        FastCopyHashSet<String> pathSet = new FastCopyHashSet<String>(1024);
        FastCopyHashSet<String> jarSet = new FastCopyHashSet<String>(1024);
        String sunBootClassPath = AccessController.doPrivileged(new PropertyReadAction("sun.boot.class.path"));
        String javaClassPath = AccessController.doPrivileged(new PropertyReadAction("java.class.path"));
        SystemLocalLoader.processClassPathItem(sunBootClassPath, jarSet, pathSet);
        SystemLocalLoader.processClassPathItem(javaClassPath, jarSet, pathSet);
        this.pathSet = pathSet;
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        ClassLoader scl = SYSTEM_CL;
        try {
            return Class.forName(name, resolve, scl);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        Enumeration<URL> urls;
        try {
            urls = SYSTEM_CL.getResources(name);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        while (urls.hasMoreElements()) {
            list.add(new URLResource(urls.nextElement()));
        }
        return list;
    }

    @Override
    public Resource loadResourceLocal(String root, String name) {
        if (!"".equals(root)) {
            return null;
        }
        URL url = SYSTEM_CL.getResource(name);
        return url == null ? null : new URLResource(url);
    }

    static SystemLocalLoader getInstance() {
        return INSTANCE;
    }

    Set<String> getPathSet() {
        return this.pathSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processClassPathItem(String classPath, Set<String> jarSet, Set<String> pathSet) {
        int e;
        if (classPath == null) {
            return;
        }
        int s = 0;
        do {
            String item;
            String string = item = (e = classPath.indexOf(File.pathSeparatorChar, s)) == -1 ? classPath.substring(s) : classPath.substring(s, e);
            if (!jarSet.contains(item)) {
                File file = new File(item);
                if (file.isDirectory()) {
                    SystemLocalLoader.processDirectory0(pathSet, file);
                } else {
                    try {
                        ZipFile zipFile = new ZipFile(file);
                        try {
                            Enumeration<? extends ZipEntry> entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                String dirName;
                                ZipEntry entry = entries.nextElement();
                                String name = entry.getName();
                                int lastSlash = name.lastIndexOf(47);
                                if (lastSlash == -1 || (dirName = name.substring(0, lastSlash)).equals("META-INF")) continue;
                                pathSet.add(dirName);
                            }
                        }
                        finally {
                            zipFile.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            s = e + 1;
        } while (e != -1);
    }

    private static void processDirectory0(Set<String> pathSet, File file) {
        for (File entry : file.listFiles()) {
            if (entry.getName().equals("META-INF")) continue;
            if (entry.isDirectory()) {
                SystemLocalLoader.processDirectory1(pathSet, entry, file.getPath());
                continue;
            }
            String parent = entry.getParent();
            if (parent == null) continue;
            pathSet.add(parent);
        }
    }

    private static void processDirectory1(Set<String> pathSet, File file, String pathBase) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                SystemLocalLoader.processDirectory1(pathSet, entry, pathBase);
                continue;
            }
            String packagePath = entry.getParent();
            if (packagePath == null) continue;
            if ((packagePath = packagePath.substring(pathBase.length()).replace('\\', '/')).startsWith("/")) {
                packagePath = packagePath.substring(1);
            }
            pathSet.add(packagePath);
        }
    }
}

